/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.testsupport.common;

import com.adobe.testing.s3mock.S3MockApplication;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public abstract class S3MockStarter {
    protected S3MockApplication s3MockFileStore;
    protected final Map<String, Object> properties = this.defaultProps();

    protected S3MockStarter(Map<String, Object> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    protected Map<String, Object> defaultProps() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("server.port", "0");
        args.put("http.port", "0");
        return args;
    }

    public AmazonS3 createS3Client() {
        return this.createS3Client("us-east-1");
    }

    public AmazonS3 createS3Client(String region) {
        BasicAWSCredentials credentials = new BasicAWSCredentials("foo", "bar");
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withClientConfiguration(this.configureClientToIgnoreInvalidSslCertificates(new ClientConfiguration()))).withEndpointConfiguration(this.getEndpointCongiguration(region))).enablePathStyleAccess()).build();
    }

    public int getPort() {
        return this.s3MockFileStore.getPort();
    }

    public int getHttpPort() {
        return this.s3MockFileStore.getHttpPort();
    }

    public void registerKMSKeyRef(String keyRef) {
        this.s3MockFileStore.registerKMSKeyRef(keyRef);
    }

    public ClientConfiguration configureClientToIgnoreInvalidSslCertificates(ClientConfiguration clientConfiguration) {
        clientConfiguration.getApacheHttpClientConfig().withSslSocketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(this.createBlindlyTrustingSslContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        return clientConfiguration;
    }

    protected AwsClientBuilder.EndpointConfiguration getEndpointCongiguration(String region) {
        boolean isSecureConnection = (Boolean)this.properties.getOrDefault("secureConnection", true);
        String serviceEndpoint = isSecureConnection ? "https://localhost:" + this.getPort() : "http://localhost:" + this.getHttpPort();
        return new AwsClientBuilder.EndpointConfiguration(serviceEndpoint, region);
    }

    protected void start() {
        this.s3MockFileStore = S3MockApplication.start(this.properties, (String[])new String[0]);
    }

    protected void stop() {
        this.s3MockFileStore.stop();
    }

    private SSLContext createBlindlyTrustingSslContext() {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new X509ExtendedTrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1, Socket arg2) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1, SSLEngine arg2) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1, Socket arg2) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1, SSLEngine arg2) {
                }
            }}, new SecureRandom());
            return sc;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public static abstract class BaseBuilder<T extends S3MockStarter> {
        protected final Map<String, Object> arguments = new HashMap<String, Object>();

        public BaseBuilder<T> withInitialBuckets(String ... initialBuckets) {
            this.arguments.put("initialBuckets", String.join((CharSequence)",", initialBuckets));
            return this;
        }

        public BaseBuilder<T> withHttpsPort(int httpsPort) {
            this.arguments.put("server.port", String.valueOf(httpsPort));
            return this;
        }

        public BaseBuilder<T> withHttpPort(int httpPort) {
            this.arguments.put("http.port", String.valueOf(httpPort));
            return this;
        }

        public BaseBuilder<T> withRootFolder(String rootFolder) {
            this.arguments.put("root", rootFolder);
            return this;
        }

        public BaseBuilder<T> withSecureConnection(boolean secureConnection) {
            this.arguments.put("secureConnection", secureConnection);
            return this;
        }

        public BaseBuilder<T> silent() {
            this.arguments.put("silent", true);
            return this;
        }

        public abstract T build();
    }
}

