/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.Batch;
import com.aerospike.client.command.BatchStatus;
import com.aerospike.client.policy.BatchPolicy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class BatchExecutor {
    private final BatchStatus status;
    private final ExecutorService threadPool;
    private final AtomicBoolean done;
    private final AtomicInteger completedCount;
    private final Batch.BatchCommand[] commands;
    private final int maxConcurrentThreads;
    private boolean completed;

    public static void execute(Cluster cluster, BatchPolicy policy, Batch.BatchCommand[] commands, BatchStatus status) {
        if (policy.maxConcurrentThreads == 1 || commands.length <= 1) {
            for (Batch.BatchCommand command : commands) {
                try {
                    command.execute();
                }
                catch (AerospikeException ae) {
                    if (!command.splitRetry) {
                        command.setInDoubt(ae.getInDoubt());
                    }
                    status.setException(ae);
                    if (policy.respondAllKeys) continue;
                    throw ae;
                }
                catch (RuntimeException re) {
                    if (!command.splitRetry) {
                        command.setInDoubt(true);
                    }
                    status.setException(re);
                    if (policy.respondAllKeys) continue;
                    throw re;
                }
            }
            status.checkException();
            return;
        }
        BatchExecutor executor = new BatchExecutor(cluster, policy, commands, status);
        executor.execute();
    }

    private BatchExecutor(Cluster cluster, BatchPolicy policy, Batch.BatchCommand[] commands, BatchStatus status) {
        this.commands = commands;
        this.status = status;
        this.threadPool = cluster.getThreadPool();
        this.done = new AtomicBoolean();
        this.completedCount = new AtomicInteger();
        this.maxConcurrentThreads = policy.maxConcurrentThreads == 0 || policy.maxConcurrentThreads >= commands.length ? commands.length : policy.maxConcurrentThreads;
    }

    void execute() {
        for (int i = 0; i < this.maxConcurrentThreads; ++i) {
            Batch.BatchCommand cmd = this.commands[i];
            cmd.parent = this;
            this.threadPool.execute(cmd);
        }
        this.waitTillComplete();
        this.status.checkException();
    }

    void onComplete() {
        int finished = this.completedCount.incrementAndGet();
        if (finished < this.commands.length) {
            int nextThread = finished + this.maxConcurrentThreads - 1;
            if (nextThread < this.commands.length && !this.done.get()) {
                Batch.BatchCommand cmd = this.commands[nextThread];
                cmd.parent = this;
                this.threadPool.execute(cmd);
            }
        } else if (this.done.compareAndSet(false, true)) {
            this.notifyCompleted();
        }
    }

    boolean isDone() {
        return this.done.get();
    }

    private synchronized void waitTillComplete() {
        while (!this.completed) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyCompleted() {
        this.completed = true;
        super.notify();
    }
}

