/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.lua.LuaData;
import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.lua.LuaUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public final class LuaMap
extends LuaUserdata
implements LuaData {
    private final LuaInstance instance;
    private final Map<LuaValue, LuaValue> map;

    public LuaMap(LuaInstance instance, Map<LuaValue, LuaValue> map) {
        super(map);
        this.instance = instance;
        this.map = map;
        this.setmetatable(instance.getPackage("Map"));
    }

    public LuaInteger size() {
        return LuaInteger.valueOf((int)this.map.size());
    }

    public LuaString toLuaString() {
        return LuaString.valueOf((String)this.map.toString());
    }

    public LuaValue get(LuaValue key) {
        LuaValue val = this.map.get(key);
        return val != null ? val : NIL;
    }

    public void put(LuaValue key, LuaValue value) {
        this.map.put(key, value);
    }

    public Iterator<Map.Entry<LuaValue, LuaValue>> entrySetIterator() {
        return this.map.entrySet().iterator();
    }

    public Iterator<LuaValue> keySetIterator() {
        return this.map.keySet().iterator();
    }

    public Iterator<LuaValue> valuesIterator() {
        return this.map.values().iterator();
    }

    public void remove(LuaValue key) {
        this.map.remove(key);
    }

    public LuaMap clone() {
        return new LuaMap(this.instance, new HashMap<LuaValue, LuaValue>(this.map));
    }

    public LuaMap merge(LuaMap map2, LuaFunction func) {
        HashMap<LuaValue, LuaValue> target = new HashMap<LuaValue, LuaValue>(this.map.size() + map2.map.size());
        target.putAll(this.map);
        boolean hasFunc = func != null && !func.isnil();
        for (Map.Entry<LuaValue, LuaValue> entry : map2.map.entrySet()) {
            LuaValue value;
            if (hasFunc && (value = this.map.get(entry.getKey())) != null) {
                Varargs ret = func.invoke(value, (Varargs)entry.getValue());
                target.put(entry.getKey(), (LuaValue)ret);
                continue;
            }
            target.put(entry.getKey(), entry.getValue());
        }
        return new LuaMap(this.instance, target);
    }

    public LuaMap diff(LuaMap map2) {
        HashMap<LuaValue, LuaValue> target = new HashMap<LuaValue, LuaValue>(this.map.size() + map2.map.size());
        for (Map.Entry<LuaValue, LuaValue> entry : this.map.entrySet()) {
            if (map2.map.containsKey(entry.getKey())) continue;
            target.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<LuaValue, LuaValue> entry : map2.map.entrySet()) {
            if (this.map.containsKey(entry.getKey())) continue;
            target.put(entry.getKey(), entry.getValue());
        }
        return new LuaMap(this.instance, target);
    }

    @Override
    public Object luaToObject() {
        HashMap<Object, Object> target = new HashMap<Object, Object>(this.map.size());
        for (Map.Entry<LuaValue, LuaValue> entry : this.map.entrySet()) {
            Object key = LuaUtil.luaToObject(entry.getKey());
            Object value = LuaUtil.luaToObject(entry.getValue());
            target.put(key, value);
        }
        return target;
    }
}

