/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.aerospike.data;

import com.aerospike.client.Host;
import com.aerospike.client.policy.ClientPolicy;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.aerospike.data.AerospikeDataAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.aerospike.AerospikeProperties;
import org.springframework.boot.autoconfigure.data.aerospike.AerospikeDataProperties;
import org.springframework.boot.autoconfigure.util.AerospikeConfigurationUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.aerospike.config.AbstractAerospikeDataConfiguration;
import org.springframework.data.aerospike.config.AerospikeDataSettings;

@Configuration
@AutoConfigureAfter(value={AerospikeDataAutoConfiguration.class})
public class AerospikeDataConfiguration
extends AbstractAerospikeDataConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AerospikeDataConfiguration.class);
    @Autowired
    private AerospikeProperties properties;
    @Autowired
    private AerospikeDataProperties dataProperties;

    protected Collection<Host> getHosts() {
        return AerospikeConfigurationUtils.getClientHosts((AerospikeProperties)this.properties);
    }

    protected String nameSpace() {
        return AerospikeConfigurationUtils.getNamespace((AerospikeDataProperties)this.dataProperties);
    }

    protected ClientPolicy getClientPolicy() {
        return AerospikeConfigurationUtils.getClientPolicyConfig((ClientPolicy)super.getClientPolicy(), (AerospikeProperties)this.properties);
    }

    protected void configureDataSettings(AerospikeDataSettings aerospikeDataSettings) {
        AerospikeConfigurationUtils.getDataSettings((AerospikeDataProperties)this.dataProperties, (AerospikeDataSettings)aerospikeDataSettings);
    }
}

