/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.Key;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

final class EntitiesKeys {
    private final Class<?>[] entityClasses;
    private final Key[] keys;

    public static EntitiesKeys of(Map<Class<?>, List<Key>> entitiesKeys) {
        Class[] entityClasses = (Class[])entitiesKeys.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(item -> (Class)entry.getKey())).toArray(Class[]::new);
        Key[] keys = (Key[])entitiesKeys.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).toArray(Key[]::new);
        return EntitiesKeys.builder().entityClasses(entityClasses).keys(keys).build();
    }

    EntitiesKeys(Class<?>[] entityClasses, Key[] keys) {
        this.entityClasses = entityClasses;
        this.keys = keys;
    }

    public static EntitiesKeysBuilder builder() {
        return new EntitiesKeysBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntitiesKeys)) {
            return false;
        }
        EntitiesKeys other = (EntitiesKeys)o;
        if (!Arrays.deepEquals(this.getEntityClasses(), other.getEntityClasses())) {
            return false;
        }
        return Arrays.deepEquals(this.getKeys(), other.getKeys());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getEntityClasses());
        result = result * 59 + Arrays.deepHashCode(this.getKeys());
        return result;
    }

    public String toString() {
        return "EntitiesKeys(entityClasses=" + Arrays.deepToString(this.getEntityClasses()) + ", keys=" + Arrays.deepToString(this.getKeys()) + ")";
    }

    public Class<?>[] getEntityClasses() {
        return this.entityClasses;
    }

    public Key[] getKeys() {
        return this.keys;
    }

    public static class EntitiesKeysBuilder {
        private Class<?>[] entityClasses;
        private Key[] keys;

        EntitiesKeysBuilder() {
        }

        public EntitiesKeysBuilder entityClasses(Class<?>[] entityClasses) {
            this.entityClasses = entityClasses;
            return this;
        }

        public EntitiesKeysBuilder keys(Key[] keys) {
            this.keys = keys;
            return this;
        }

        public EntitiesKeys build() {
            return new EntitiesKeys(this.entityClasses, this.keys);
        }

        public String toString() {
            return "EntitiesKeys.EntitiesKeysBuilder(entityClasses=" + Arrays.deepToString(this.entityClasses) + ", keys=" + Arrays.deepToString(this.keys) + ")";
        }
    }
}

