/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.data.aerospike.IndexAlreadyExistsException;
import org.springframework.data.aerospike.core.ReactiveAerospikeTemplate;
import org.springframework.data.aerospike.index.AerospikeIndexDefinition;
import org.springframework.data.aerospike.index.AerospikeIndexResolver;
import org.springframework.data.aerospike.index.BaseAerospikePersistenceEntityIndexCreator;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAerospikePersistenceEntityIndexCreator
extends BaseAerospikePersistenceEntityIndexCreator {
    private static final Logger log = LoggerFactory.getLogger(ReactiveAerospikePersistenceEntityIndexCreator.class);
    private final ReactiveAerospikeTemplate template;

    public ReactiveAerospikePersistenceEntityIndexCreator(ObjectProvider<AerospikeMappingContext> mappingContext, boolean createIndexesOnStartup, AerospikeIndexResolver aerospikeIndexResolver, ReactiveAerospikeTemplate template) {
        super(mappingContext, createIndexesOnStartup, aerospikeIndexResolver);
        this.template = template;
    }

    @Override
    protected void installIndexes(Set<AerospikeIndexDefinition> indexes) {
        Flux.fromIterable(indexes).flatMap(this::installIndex).then().block();
    }

    private Mono<Void> installIndex(AerospikeIndexDefinition index) {
        log.debug("Installing aerospike index: {}...", (Object)index);
        return this.template.createIndex(index.getEntityClass(), index.getName(), index.getFieldName(), index.getType(), index.getCollectionType()).doOnSuccess(__ -> log.info("Installed aerospike index: {} successfully.", (Object)index)).onErrorResume(IndexAlreadyExistsException.class, e -> this.onIndexAlreadyExists((Throwable)((Object)e), index)).doOnError(throwable -> log.error("Failed to install aerospike index: " + index, throwable));
    }

    private Mono<? extends Void> onIndexAlreadyExists(Throwable throwable, AerospikeIndexDefinition indexDefinition) {
        log.info("Skipping index [{}] creation. Index with the same name already exists. {}", (Object)indexDefinition, (Object)throwable.getMessage());
        return Mono.empty();
    }
}

