/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.cache;

import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.query.cache.IndexesCacheUpdater;
import org.springframework.data.aerospike.query.cache.InternalIndexOperations;
import org.springframework.data.aerospike.query.model.IndexesInfo;
import reactor.core.publisher.Mono;

public class ReactorIndexRefresher {
    private static final Logger log = LoggerFactory.getLogger(ReactorIndexRefresher.class);
    private final IAerospikeReactorClient client;
    private final InfoPolicy infoPolicy;
    private final InternalIndexOperations indexOperations;
    private final IndexesCacheUpdater indexesCacheUpdater;

    public ReactorIndexRefresher(IAerospikeReactorClient client, InfoPolicy infoPolicy, InternalIndexOperations indexOperations, IndexesCacheUpdater indexesCacheUpdater) {
        this.client = client;
        this.infoPolicy = infoPolicy;
        this.indexOperations = indexOperations;
        this.indexesCacheUpdater = indexesCacheUpdater;
    }

    public Mono<Void> refreshIndexes() {
        return this.client.info(this.infoPolicy, null, this.indexOperations.buildGetIndexesCommand()).doOnSubscribe(subscription -> log.trace("Loading indexes")).doOnNext(indexInfo -> {
            IndexesInfo cache = this.indexOperations.parseIndexesInfo((String)indexInfo);
            this.indexesCacheUpdater.update(cache);
            log.debug("Loaded indexes: {}", cache.indexes);
        }).then();
    }
}

