/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.repository.query.BaseAerospikePartTreeQuery;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;

public class AerospikePartTreeQuery
extends BaseAerospikePartTreeQuery {
    private final AerospikeOperations aerospikeOperations;

    public AerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evalContextProvider, AerospikeOperations aerospikeOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evalContextProvider, queryCreator);
        this.aerospikeOperations = aerospikeOperations;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Query query = this.prepareQuery(parameters, accessor);
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            Stream<?> result = this.findByQuery(query);
            long total = this.queryMethod.isSliceQuery() ? 0L : this.aerospikeOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
            return new PageImpl(result.collect(Collectors.toList()), accessor.getPageable(), total);
        }
        if (this.queryMethod.isStreamQuery()) {
            return this.findByQuery(query);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.findByQuery(query).collect(Collectors.toList());
        }
        if (this.queryMethod.isQueryForEntity()) {
            Stream<?> result = this.findByQuery(query);
            return result.findFirst().orElse(null);
        }
        throw new UnsupportedOperationException("Query method " + this.queryMethod.getNamedQueryName() + " not supported.");
    }

    private Stream<?> findByQuery(Query query) {
        return this.aerospikeOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
    }
}

