/*
 * Decompiled with CFR 0.152.
 */
package com.aerse.uploader;

import com.aerse.uploader.Callback;
import com.aerse.uploader.FileEntry;
import com.aerse.uploader.ListRequest;
import com.aerse.uploader.UploadException;
import com.aerse.uploader.Uploader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploaderToFile
implements Uploader {
    private static final Logger LOG = LoggerFactory.getLogger(UploaderToFile.class);
    private String basePath;
    private File basePathDir;

    @PostConstruct
    public void start() {
        this.basePathDir = UploaderToFile.initDir(this.basePath);
    }

    @Override
    public List<FileEntry> listFiles(final ListRequest req) {
        LOG.info("listing: {}", (Object)req);
        Collection it = FileUtils.listFiles((File)new File(this.basePath), (IOFileFilter)new IOFileFilter(){

            public boolean accept(File dir, String name) {
                return this.accept(new File(dir, name));
            }

            public boolean accept(File file) {
                if (req.getPrefix() == null) {
                    return true;
                }
                return file.getAbsolutePath().startsWith(UploaderToFile.this.basePathDir.getAbsolutePath() + req.getPrefix());
            }
        }, (IOFileFilter)TrueFileFilter.INSTANCE);
        boolean foundMarker = false;
        File markerFile = req.getMarker() != null ? new File(this.basePathDir.getAbsolutePath() + req.getMarker()) : null;
        ArrayList sorted = new ArrayList(it);
        Collections.sort(sorted);
        ArrayList<FileEntry> result = new ArrayList<FileEntry>();
        for (File cur : sorted) {
            if (markerFile != null && !foundMarker) {
                if (!cur.getAbsolutePath().equals(markerFile.getAbsolutePath())) continue;
                foundMarker = true;
                continue;
            }
            result.add(this.convert(cur));
            if (result.size() < req.getLimit() && result.size() < 10000) continue;
            break;
        }
        return result;
    }

    private FileEntry convert(File cur) {
        String fileName = cur.getAbsolutePath();
        String basePathName = this.basePathDir.getAbsolutePath();
        FileEntry result = new FileEntry();
        result.setBytes(cur.length());
        result.setName(fileName.substring(basePathName.length()));
        result.setLast_modified(new Date(cur.lastModified()).toString());
        return result;
    }

    @Override
    public void delete(String path) throws UploadException {
        LOG.info("deleting: {}", (Object)path);
        File newPath = new File(this.basePath + path);
        if (!newPath.exists()) {
            return;
        }
        if (newPath.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)newPath);
            }
            catch (IOException e) {
                throw new UploadException(503, "unable to delete directory: " + newPath.getAbsolutePath(), e);
            }
        } else if (newPath.isFile() && !newPath.delete()) {
            throw new UploadException(503, "unable to delete file: " + newPath.getAbsolutePath());
        }
    }

    @Override
    public void submit(File file, String path) throws UploadException {
        LOG.info("submitting: {}", (Object)path);
        File newPath = new File(this.basePath + path);
        if (!newPath.getParentFile().exists() && !newPath.getParentFile().mkdirs()) {
            throw new UploadException("Unable to create dirs: " + newPath.getParentFile().getAbsolutePath());
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(newPath);
            fis = new FileInputStream(file);
            IOUtils.copy((InputStream)fis, (OutputStream)fos);
        }
        catch (IOException e) {
            throw new UploadException(503, "unable to copy", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOG.info("unable to close cursors", (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    LOG.info("unable to close cursors", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String path, Callback f) {
        LOG.info("downloading: {}", (Object)path);
        File filePath = new File(this.basePath + path);
        if (filePath.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(filePath);
                f.onData(fis);
            }
            catch (Exception e) {
                try {
                    LOG.error("unable to callback", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    private static File initDir(String dir) {
        File tempDirFile = new File(dir);
        if (tempDirFile.exists() && !tempDirFile.isDirectory()) {
            throw new IllegalStateException("is not a directory: " + tempDirFile.getAbsolutePath());
        }
        if (!tempDirFile.exists() && !tempDirFile.mkdirs()) {
            throw new IllegalStateException("unable to create: " + tempDirFile.getAbsolutePath());
        }
        return tempDirFile;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

