/*
 * Decompiled with CFR 0.152.
 */
package com.aerse.uploader;

import com.aerse.uploader.Callback;
import com.aerse.uploader.FileEntry;
import com.aerse.uploader.ListRequest;
import com.aerse.uploader.UploadException;
import com.aerse.uploader.Uploader;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploaderToSelectel
implements Uploader {
    private static final Logger LOG = LoggerFactory.getLogger(UploaderToSelectel.class);
    private static final String INTERNAL_SERVER_ERROR = "\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0437\u0434\u043d\u0435\u0435";
    private String user;
    private String key;
    private String containerName;
    private int timeout;
    private int retries;
    private long retryTimeoutMillis;
    private String authToken;
    private String baseUrl;
    private long validUntil;
    private CloseableHttpClient client;

    @PostConstruct
    public void start() {
        this.client = this.createClient();
    }

    @PreDestroy
    public void stop() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public void delete(String path) throws UploadException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("deleting: {}", (Object)path);
        }
        int retryCount = 0;
        while (true) {
            CloseableHttpResponse result = null;
            try {
                String authToken = this.getAuthToken();
                HttpDelete del = new HttpDelete(this.baseUrl + "/" + this.containerName + path);
                del.addHeader("X-Auth-Token", authToken);
                result = this.client.execute((HttpUriRequest)del);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("response: {}", (Object)EntityUtils.toString((HttpEntity)result.getEntity()));
                }
                if (result.getStatusLine().getStatusCode() == 204) {
                    return;
                }
                if (result.getStatusLine().getStatusCode() == 401) {
                    ++retryCount;
                    this.resetAuthToken();
                    continue;
                }
                try {
                    throw new UploadException(result.getStatusLine().getStatusCode(), INTERNAL_SERVER_ERROR);
                }
                catch (IOException e) {
                    if (retryCount < this.retries) {
                        LOG.info("unable to delete: {} retry...{} exception {}", new Object[]{e.getMessage(), ++retryCount, e.getMessage()});
                        try {
                            Thread.sleep(this.retryTimeoutMillis);
                            continue;
                        }
                        catch (InterruptedException e1) {
                            LOG.info("sleep interrupted. exit");
                            break;
                        }
                    }
                    throw new UploadException(503, INTERNAL_SERVER_ERROR, e);
                }
            }
            finally {
                if (result == null) continue;
                EntityUtils.consumeQuietly((HttpEntity)result.getEntity());
                continue;
            }
            break;
        }
    }

    @Override
    public void submit(File file, String path) throws UploadException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("submitting: {}", (Object)path);
        }
        int retryCount = 0;
        while (true) {
            CloseableHttpResponse result = null;
            try {
                String authToken = this.getAuthToken();
                HttpPut put = new HttpPut(this.baseUrl + "/" + this.containerName + path);
                put.addHeader("X-Auth-Token", authToken);
                put.setEntity((HttpEntity)new FileEntity(file));
                result = this.client.execute((HttpUriRequest)put);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("response: {}", (Object)EntityUtils.toString((HttpEntity)result.getEntity()));
                }
                if (result.getStatusLine().getStatusCode() == 201) {
                    if (retryCount > 0) {
                        LOG.info("submitted: {}", (Object)path);
                    }
                    return;
                }
                if (result.getStatusLine().getStatusCode() == 401) {
                    ++retryCount;
                    this.resetAuthToken();
                    continue;
                }
                try {
                    throw new UploadException(result.getStatusLine().getStatusCode(), "invalid response: " + result.getStatusLine());
                }
                catch (IOException e) {
                    if (retryCount < 3) {
                        LOG.info("unable to submit: {} retry...{} exception {}", new Object[]{path, ++retryCount, e.getMessage()});
                        try {
                            Thread.sleep(this.retryTimeoutMillis);
                            continue;
                        }
                        catch (InterruptedException e1) {
                            LOG.info("sleep interrupted. exit");
                            break;
                        }
                    }
                    throw new UploadException(503, INTERNAL_SERVER_ERROR, e);
                }
            }
            finally {
                if (result == null) continue;
                EntityUtils.consumeQuietly((HttpEntity)result.getEntity());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileEntry> listFiles(ListRequest req) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("listing: {}", (Object)req);
        }
        String authToken2 = this.getAuthToken();
        StringBuilder builder = new StringBuilder();
        builder.append(this.baseUrl).append("/").append(this.containerName).append("?format=json");
        if (req.getLimit() > 0) {
            builder.append("&limit=").append(req.getLimit());
        }
        if (req.getMarker() != null) {
            try {
                builder.append("&marker=").append(URLEncoder.encode(req.getMarker(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return Collections.emptyList();
            }
        }
        if (req.getPrefix() != null) {
            builder.append("&prefix=").append(req.getPrefix());
        }
        if (req.getPath() != null) {
            builder.append("&path=").append(req.getPath());
        }
        if (req.getDelimiter() != null) {
            builder.append("&delimiter=").append(req.getDelimiter());
        }
        HttpGet m = new HttpGet(builder.toString());
        m.addHeader("X-Auth-Token", authToken2);
        CloseableHttpResponse result = null;
        try {
            result = this.client.execute((HttpUriRequest)m);
            if (result.getStatusLine().getStatusCode() != 200) {
                LOG.info("invalid response: {}", (Object)result.getStatusLine());
                List<FileEntry> list = Collections.emptyList();
                return list;
            }
            Type typeOfSrc = new TypeToken<List<FileEntry>>(){}.getType();
            List list = (List)new Gson().fromJson((Reader)new InputStreamReader(result.getEntity().getContent(), StandardCharsets.UTF_8), typeOfSrc);
            return list;
        }
        catch (Exception e) {
            LOG.error("unable to list files", (Throwable)e);
            List<FileEntry> list = Collections.emptyList();
            return list;
        }
        finally {
            if (result != null) {
                EntityUtils.consumeQuietly((HttpEntity)result.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String path, Callback f) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("downloading: {}", (Object)path);
        }
        String authToken2 = this.getAuthToken();
        HttpGet put = new HttpGet(this.baseUrl + "/" + this.containerName + path);
        put.addHeader("X-Auth-Token", authToken2);
        CloseableHttpResponse result = null;
        try {
            result = this.client.execute((HttpUriRequest)put);
            if (result.getStatusLine().getStatusCode() != 200) {
                LOG.info("unable to download: {}", (Object)EntityUtils.toString((HttpEntity)result.getEntity()));
            } else {
                f.onData(result.getEntity().getContent());
            }
        }
        catch (Exception e) {
            LOG.error("unable to download", (Throwable)e);
        }
        finally {
            if (result != null) {
                EntityUtils.consumeQuietly((HttpEntity)result.getEntity());
            }
        }
    }

    private synchronized String getAuthToken() {
        if (this.authToken == null || System.currentTimeMillis() > this.validUntil) {
            if (this.authToken != null) {
                LOG.info("re-newing auth token");
            }
            long start = System.currentTimeMillis();
            HttpGet get = new HttpGet("https://auth.selcdn.ru");
            get.addHeader("X-Auth-User", this.user);
            get.addHeader("X-Auth-Key", this.key);
            CloseableHttpResponse response = null;
            try {
                response = this.client.execute((HttpUriRequest)get);
                if (response.getStatusLine().getStatusCode() != 204) {
                    LOG.info("unable to auth: {}", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
                    throw new RuntimeException(INTERNAL_SERVER_ERROR);
                }
                this.authToken = response.getFirstHeader("X-Auth-Token").getValue();
                this.baseUrl = response.getFirstHeader("X-Storage-Url").getValue();
                this.validUntil = start + Long.valueOf(response.getFirstHeader("X-Expire-Auth-Token").getValue()) * 1000L - (long)this.timeout;
                LOG.info("the token will expire at: {}", (Object)new Date(this.validUntil));
            }
            catch (IOException e) {
                throw new RuntimeException(INTERNAL_SERVER_ERROR, e);
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
        }
        return this.authToken;
    }

    private synchronized void resetAuthToken() {
        LOG.info("not authorized. resetting auth token");
        this.authToken = null;
    }

    private CloseableHttpClient createClient() {
        return UploaderToSelectel.createClient(this.timeout);
    }

    static CloseableHttpClient createClient(int timeout) {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.addInterceptorFirst((HttpRequestInterceptor)new RequestAcceptEncoding());
        builder.addInterceptorFirst((HttpResponseInterceptor)new ResponseContentEncoding());
        builder.setConnectionManager((HttpClientConnectionManager)cm);
        builder.setUserAgent("AerseUploader (1.17)");
        builder.setDefaultRequestConfig(requestConfig);
        return builder.build();
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setRetryTimeoutMillis(long retryTimeoutMillis) {
        this.retryTimeoutMillis = retryTimeoutMillis;
    }
}

