/*
 * Decompiled with CFR 0.152.
 */
package com.agile4j.model.builder.utils;

import com.agile4j.model.builder.delegate.Descriptor;
import com.agile4j.model.builder.delegate.RDesc;
import com.agile4j.model.builder.exception.ModelBuildException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.reflect.jvm.ReflectLambdaKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001b\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013\u001a&\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00012\f\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001\u001aF\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u001d0\u001b\"\u0004\b\u0000\u0010\u001c\"\u0004\b\u0001\u0010\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u001d0\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u001d0\u001b\u001a(\u0010!\u001a\b\u0012\u0004\u0012\u0002H\"0\u0013\"\u0004\b\u0000\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0$2\u0006\u0010\u000f\u001a\u00020%\u001a\u0010\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)\u001a\u000e\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020'\"4\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"6\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\"2\u0010\t\u001a\u0004\u0018\u00010\n\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006+"}, d2={"nonNullReturnKClazz", "Lkotlin/reflect/KClass;", "P", "R", "Lkotlin/Function1;", "getNonNullReturnKClazz", "(Lkotlin/jvm/functions/Function1;)Lkotlin/reflect/KClass;", "returnKClazz", "getReturnKClazz", "returnKType", "Lkotlin/reflect/KType;", "getReturnKType", "(Lkotlin/jvm/functions/Function1;)Lkotlin/reflect/KType;", "empty", "JR", "desc", "Lcom/agile4j/model/builder/delegate/RDesc;", "(Lcom/agile4j/model/builder/delegate/RDesc;)Ljava/lang/Object;", "flatAndFilterNonNull", "", "", "coll", "getConstructor", "Lkotlin/reflect/KFunction;", "tClazz", "aClazz", "merge", "", "K", "V", "map1", "", "map2", "parseColl", "E", "list", "", "Lcom/agile4j/model/builder/delegate/Descriptor;", "unifyTypeName", "", "type", "Ljava/lang/reflect/Type;", "typeName", "agile4j-model-builder"})
public final class ModelBuilderUtilKt {
    @NotNull
    public static final <P, R> KClass<?> getNonNullReturnKClazz(@NotNull Function1<? super P, ? extends R> $this$nonNullReturnKClazz) {
        Intrinsics.checkParameterIsNotNull($this$nonNullReturnKClazz, (String)"$this$nonNullReturnKClazz");
        KClass<?> kClass = ModelBuilderUtilKt.getReturnKClazz($this$nonNullReturnKClazz);
        if (kClass == null) {
            Void void_ = ModelBuildException.Companion.err("unKnown return kClass of function:" + $this$nonNullReturnKClazz);
            throw null;
        }
        return kClass;
    }

    @Nullable
    public static final <P, R> KClass<?> getReturnKClazz(@NotNull Function1<? super P, ? extends R> $this$returnKClazz) {
        Intrinsics.checkParameterIsNotNull($this$returnKClazz, (String)"$this$returnKClazz");
        KType kType = ModelBuilderUtilKt.getReturnKType($this$returnKClazz);
        return kType != null ? KTypesJvm.getJvmErasure((KType)kType) : null;
    }

    @Nullable
    public static final <P, R> KType getReturnKType(@NotNull Function1<? super P, ? extends R> $this$returnKType) {
        Object object;
        Intrinsics.checkParameterIsNotNull($this$returnKType, (String)"$this$returnKType");
        if ($this$returnKType instanceof KCallable) {
            object = ((KCallable)$this$returnKType).getReturnType();
        } else {
            KFunction kFunction = ReflectLambdaKt.reflect((Function)((Function)$this$returnKType));
            object = kFunction != null ? kFunction.getReturnType() : null;
        }
        return object;
    }

    @NotNull
    public static final String unifyTypeName(@Nullable Type type) {
        String string;
        if (type == null) {
            string = "";
        } else {
            String string2 = type.getTypeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"type.typeName");
            string = ModelBuilderUtilKt.unifyTypeName(string2);
        }
        return string;
    }

    @NotNull
    public static final String unifyTypeName(@NotNull String typeName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        switch (typeName) {
            case "java.lang.Long": {
                string = "long";
                break;
            }
            case "java.lang.Integer": {
                string = "int";
                break;
            }
            case "java.lang.Boolean": {
                string = "boolean";
                break;
            }
            case "java.lang.Float": {
                string = "float";
                break;
            }
            case "java.long.Double": {
                string = "double";
                break;
            }
            case "java.long.Byte": {
                string = "byte";
                break;
            }
            case "java.long.Short": {
                string = "short";
                break;
            }
            case "java.long.Character": {
                string = "char";
                break;
            }
            default: {
                string = typeName;
            }
        }
        return string;
    }

    @NotNull
    public static final Collection<Object> flatAndFilterNonNull(@NotNull Collection<? extends Object> coll) {
        Intrinsics.checkParameterIsNotNull(coll, (String)"coll");
        boolean bl = false;
        Set result = new LinkedHashSet();
        Iterable $this$forEach$iv = coll;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl2 = false;
            if (it == null) continue;
            Collection c = (Collection)it;
            Iterable $this$forEach$iv2 = c;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv2;
                Object e = element$iv2 = iterator2.next();
                boolean bl3 = false;
                if (e == null) continue;
                result.add(e);
            }
        }
        return result;
    }

    @Nullable
    public static final <JR> JR empty(@NotNull RDesc desc) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        if (!desc.isColl()) {
            return null;
        }
        Collection emptyColl = desc.isSet() ? (Collection)SetsKt.emptySet() : (Collection)CollectionsKt.emptyList();
        return (JR)emptyColl;
    }

    @NotNull
    public static final <E> Collection<E> parseColl(@NotNull List<? extends E> list, @NotNull Descriptor desc) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        return desc.isSet() ? (Collection)CollectionsKt.toSet((Iterable)list) : (Collection)list;
    }

    @NotNull
    public static final <K, V> Map<K, V> merge(@NotNull Map<K, V> map1, @NotNull Map<K, ? extends V> map2) {
        Map<K, ? extends V> map;
        Intrinsics.checkParameterIsNotNull(map1, (String)"map1");
        Intrinsics.checkParameterIsNotNull(map2, (String)"map2");
        if (map1.isEmpty()) {
            map = map2;
        } else {
            map1.putAll(map2);
            map = map1;
        }
        return map;
    }

    @Nullable
    public static final KFunction<?> getConstructor(@NotNull KClass<?> tClazz, @Nullable KClass<?> aClazz) {
        Intrinsics.checkParameterIsNotNull(tClazz, (String)"tClazz");
        for (KFunction function : tClazz.getConstructors()) {
            if (function.getParameters().size() != 1) continue;
            KClass<?> kClass = aClazz;
            if (!Intrinsics.areEqual((Object)((KParameter)function.getParameters().get(0)).getType(), kClass != null ? KClassifiers.createType$default((KClassifier)((KClassifier)kClass), null, (boolean)false, null, (int)7, null) : null)) continue;
            return function;
        }
        return null;
    }
}

