/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.gru.micronaut;

import com.agorapulse.gru.Client;
import com.agorapulse.gru.GruContext;
import com.agorapulse.gru.LazyClient;
import com.agorapulse.gru.Squad;
import com.agorapulse.gru.http.Http;
import com.agorapulse.gru.minions.Minion;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.runtime.server.EmbeddedServer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Micronaut
implements Client {
    private final ApplicationContextProvider contextProvider;
    private final Client delegate;

    public static MicronautApplicationBuilder build(Object unitTest) {
        return new MicronautApplicationBuilder(unitTest);
    }

    public static Client create(Object unitTest) {
        if (unitTest instanceof ApplicationContextProvider) {
            return new Micronaut((ApplicationContextProvider)unitTest, (Client)Http.create((Object)unitTest));
        }
        Micronaut.assertProviderIfPossible(unitTest);
        return Micronaut.build(unitTest).start();
    }

    public static Client createLazy(Supplier<?> unitTestProvider, ApplicationContextProvider provider) {
        return new Micronaut(provider, LazyClient.create(() -> Http.create(unitTestProvider.get())));
    }

    public static Client create(Object unitTest, ApplicationContextProvider provider) {
        return new Micronaut(provider, (Client)Http.create((Object)unitTest));
    }

    private Micronaut(ApplicationContextProvider contextProvider, Client delegate) {
        this.contextProvider = contextProvider;
        this.delegate = delegate;
    }

    public Client.Request getRequest() {
        return this.delegate.getRequest();
    }

    public Client.Response getResponse() {
        return this.delegate.getResponse();
    }

    public void reset() {
        if (this.contextProvider instanceof Closeable) {
            try {
                ((Closeable)this.contextProvider).close();
            }
            catch (IOException exception) {
                throw new IllegalStateException("Cannot close " + this.contextProvider, exception);
            }
        }
        this.delegate.reset();
    }

    public GruContext run(Squad squad, GruContext context) {
        String baseUrl = ((EmbeddedServer)this.contextProvider.getApplicationContext().getBean(EmbeddedServer.class)).getURL().toExternalForm();
        this.delegate.getRequest().setBaseUri(baseUrl);
        return this.delegate.run(squad, context);
    }

    public InputStream loadFixture(String fileName) {
        return this.delegate.loadFixture(fileName);
    }

    public String getCurrentDescription() {
        return this.delegate.getCurrentDescription();
    }

    public List<Minion> getInitialSquad() {
        return this.delegate.getInitialSquad();
    }

    public Object getUnitTest() {
        return this.delegate.getUnitTest();
    }

    private static void assertProviderIfPossible(Object unitTest) {
        if (unitTest == null || unitTest instanceof ApplicationContextProvider) {
            return;
        }
        if (Arrays.stream(unitTest.getClass().getAnnotations()).anyMatch(a -> a.getClass().getSimpleName().equals("MicronautTest"))) {
            throw new IllegalArgumentException("Specification " + unitTest.getClass().getName() + " must either implement " + ApplicationContextProvider.class.getName() + " or use inject the instance using @Inject Gru gru");
        }
        Optional<Field> contextField = Arrays.stream(unitTest.getClass().getFields()).filter(f -> ApplicationContext.class.isAssignableFrom(f.getType())).findFirst();
        if (contextField.isPresent()) {
            throw new IllegalArgumentException("Specification " + unitTest.getClass().getName() + " must either implement " + ApplicationContextProvider.class.getName() + " returning value of field " + contextField.get().getName() + " or use Micronaut.create(this) { " + contextField.get().getName() + " } instead of Micronaut.create(this)");
        }
    }

    private static class SelfStartingContextProvider
    implements ApplicationContextProvider,
    Closeable {
        private final MicronautApplicationBuilder micronautApplicationBuilder;
        private ApplicationContext context;

        private SelfStartingContextProvider(MicronautApplicationBuilder builder) {
            this.micronautApplicationBuilder = builder;
        }

        public ApplicationContext getApplicationContext() {
            if (this.context != null) {
                return this.context;
            }
            ApplicationContextBuilder builder = ApplicationContext.builder();
            this.micronautApplicationBuilder.contextBuilderConfiguration.accept(builder);
            this.context = builder.build();
            this.micronautApplicationBuilder.contextConfiguration.accept(this.context);
            this.context.start();
            EmbeddedServer application = (EmbeddedServer)this.context.getBean(EmbeddedServer.class);
            application.start();
            return this.context;
        }

        @Override
        public void close() {
            this.context.close();
        }
    }

    public static class MicronautApplicationBuilder {
        private final Object unitTest;
        private Consumer<ApplicationContextBuilder> contextBuilderConfiguration = b -> {};
        private Consumer<ApplicationContext> contextConfiguration = b -> {};

        MicronautApplicationBuilder(Object unitTest) {
            this.unitTest = unitTest;
        }

        public MicronautApplicationBuilder doWithContext(Consumer<ApplicationContext> contextConfiguration) {
            this.contextConfiguration = this.contextConfiguration.andThen(contextConfiguration);
            return this;
        }

        public MicronautApplicationBuilder doWithContextBuilder(Consumer<ApplicationContextBuilder> contextBuilderConfiguration) {
            this.contextBuilderConfiguration = this.contextBuilderConfiguration.andThen(contextBuilderConfiguration);
            return this;
        }

        public Client start() {
            SelfStartingContextProvider provider = new SelfStartingContextProvider(this);
            provider.getApplicationContext().inject(this.unitTest);
            return Micronaut.create(this.unitTest, provider);
        }
    }
}

