/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.Builders;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedQuery;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedScan;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedUpdate;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.QueryBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.ScanBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.UpdateBuilder;
import io.micronaut.core.annotation.Nullable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbAsyncTable;
import software.amazon.awssdk.enhanced.dynamodb.Key;

public interface AsyncDynamoDbService<T> {
    public Class<T> getItemType();

    public DynamoDbAsyncTable<T> getTable();

    public Publisher<T> query(DetachedQuery<T> var1);

    default public Publisher<T> query(Consumer<QueryBuilder<T>> query) {
        return this.query(Builders.query(query));
    }

    public Publisher<T> scan(DetachedScan<T> var1);

    default public Publisher<T> scan(Consumer<ScanBuilder<T>> scan) {
        return this.scan(Builders.scan(scan));
    }

    public Publisher<T> findAll(Object var1, @Nullable Object var2);

    default public Publisher<T> findAll(Object partitionKey) {
        return this.findAll(partitionKey, null);
    }

    public <R> Publisher<R> update(DetachedUpdate<T, R> var1);

    default public <R> Publisher<R> update(Function<UpdateBuilder<T, T>, UpdateBuilder<T, R>> update) {
        return this.update(Builders.update(update));
    }

    public <R> Publisher<R> updateAll(Publisher<T> var1, UpdateBuilder<T, R> var2);

    default public <R> Publisher<R> updateAll(Publisher<T> items, Function<UpdateBuilder<T, T>, UpdateBuilder<T, R>> update) {
        return this.updateAll(items, Builders.update(update));
    }

    public Publisher<T> save(T var1);

    public Publisher<T> saveAll(Publisher<T> var1);

    public Publisher<T> delete(Object var1, @Nullable Object var2);

    public Publisher<T> delete(T var1);

    public Publisher<T> delete(Key var1);

    public Publisher<T> deleteAll(Publisher<T> var1);

    public Publisher<T> get(Object var1, Object var2);

    public Publisher<T> getAll(Object var1, Publisher<?> var2);

    public Publisher<T> getAll(Publisher<?> var1);

    public Publisher<T> get(Key var1);

    public Publisher<Long> count(DetachedQuery<T> var1);

    default public Publisher<Long> countUsingQuery(Consumer<QueryBuilder<T>> query) {
        return this.count(Builders.query(query));
    }

    public Publisher<Long> count(DetachedScan<T> var1);

    default public Publisher<Long> countUsingScan(Consumer<ScanBuilder<T>> scan) {
        return this.count(Builders.scan(scan));
    }

    public Publisher<Long> count(Object var1, @Nullable Object var2);

    public Publisher<Boolean> createTable();
}

