/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AsyncDynamoDBServiceProvider;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AsyncDynamoDbService;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.DynamoDbServiceIntroduction;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.FunctionEvaluator;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.SyncDynamoDbServiceIntroduction;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Query;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Scan;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Update;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedQuery;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedScan;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedUpdate;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.UpdateBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.util.ItemArgument;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.util.QueryArguments;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;

@Singleton
@Replaces(value=SyncDynamoDbServiceIntroduction.class)
@Requires(property="aws.dynamodb.async", value="true")
public class AsyncDynamoDbServiceIntroduction
implements DynamoDbServiceIntroduction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncDynamoDbServiceIntroduction.class);
    private final FunctionEvaluator functionEvaluator;
    private final AsyncDynamoDBServiceProvider provider;
    private final ConversionService conversionService;

    public AsyncDynamoDbServiceIntroduction(FunctionEvaluator functionEvaluator, AsyncDynamoDBServiceProvider provider, ConversionService conversionService) {
        this.functionEvaluator = functionEvaluator;
        this.provider = provider;
        this.conversionService = conversionService;
    }

    @Override
    public <T> Object doIntercept(MethodInvocationContext<Object, Object> context, Class<T> type, String tableName) {
        AsyncDynamoDbService service = this.provider.findOrCreate(tableName, type);
        try {
            return this.doIntercept(context, service);
        }
        catch (ResourceNotFoundException ignored) {
            return this.unwrapIfRequired((Publisher<?>)Flux.from(service.createTable()).map(t -> this.doIntercept(context, service)), context);
        }
    }

    private static void logTypeConversionFailure(Class<?> type, Object result) {
        String message = "Cannot convert value %s to type %s".formatted(result, type);
        LOGGER.warn(message, new Object[]{result, type, new IllegalArgumentException(message)});
    }

    private <T> Publisher<T> toPublisher(Class<T> type, Argument<?> itemArgument, Map<String, MutableArgumentValue<?>> params) {
        Object item = params.get(itemArgument.getName()).getValue();
        if (Publishers.isConvertibleToPublisher((Class)itemArgument.getType()) && type.isAssignableFrom(itemArgument.getTypeParameters()[0].getType())) {
            if (Publisher.class.isAssignableFrom(itemArgument.getType())) {
                return (Publisher)item;
            }
            return (Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)item, Publisher.class);
        }
        if (itemArgument.getType().isArray() && type.isAssignableFrom(itemArgument.getType().getComponentType())) {
            return Flux.fromArray((Object[])((Object[])item));
        }
        if (Iterable.class.isAssignableFrom(itemArgument.getType()) && type.isAssignableFrom(itemArgument.getTypeParameters()[0].getType())) {
            return Flux.fromIterable((Iterable)((Iterable)item));
        }
        return Flux.just((Object)item);
    }

    private <T> Object doIntercept(MethodInvocationContext<Object, Object> context, AsyncDynamoDbService<T> service) {
        Optional<ItemArgument> maybeItemArgument;
        String methodName = context.getMethodName();
        if (methodName.startsWith("save")) {
            return this.unwrapIfRequired(this.handleSave(service, context), context);
        }
        if (methodName.startsWith("get") || methodName.startsWith("load")) {
            return this.unwrapIfRequired(this.handleGet(service, context), context);
        }
        if (context.getTargetMethod().isAnnotationPresent(Query.class)) {
            DetachedQuery criteria = (DetachedQuery)this.functionEvaluator.evaluateAnnotationType(context.getTargetMethod().getAnnotation(Query.class).value(), context);
            if (methodName.startsWith("count")) {
                return this.unwrapIfRequired(service.count(criteria), context);
            }
            Publisher<T> queryResult = service.query(criteria);
            if (methodName.startsWith("delete")) {
                return this.unwrapIfRequired(service.deleteAll(queryResult), context);
            }
            if (context.getTargetMethod().isAnnotationPresent(Update.class)) {
                UpdateBuilder update = (UpdateBuilder)this.functionEvaluator.evaluateAnnotationType(context.getTargetMethod().getAnnotation(Update.class).value(), context);
                return this.unwrapIfRequired(service.updateAll(queryResult, update), context);
            }
            return this.unwrapIfRequired(queryResult, context);
        }
        if (context.getTargetMethod().isAnnotationPresent(Scan.class)) {
            DetachedScan criteria = (DetachedScan)this.functionEvaluator.evaluateAnnotationType(context.getTargetMethod().getAnnotation(Scan.class).value(), context);
            if (methodName.startsWith("count")) {
                return this.unwrapIfRequired(service.count(criteria), context);
            }
            Publisher<T> scanResult = service.scan(criteria);
            if (methodName.startsWith("delete")) {
                return this.unwrapIfRequired(service.deleteAll(scanResult), context);
            }
            if (context.getTargetMethod().isAnnotationPresent(Update.class)) {
                UpdateBuilder update = (UpdateBuilder)this.functionEvaluator.evaluateAnnotationType(context.getTargetMethod().getAnnotation(Update.class).value(), context);
                return this.unwrapIfRequired(service.updateAll(scanResult, update), context);
            }
            return this.unwrapIfRequired(scanResult, context);
        }
        if (context.getTargetMethod().isAnnotationPresent(Update.class)) {
            DetachedUpdate criteria = (DetachedUpdate)this.functionEvaluator.evaluateAnnotationType(context.getTargetMethod().getAnnotation(Update.class).value(), context);
            return this.unwrapIfRequired(service.update(criteria), context);
        }
        if (methodName.startsWith("delete") && (maybeItemArgument = ItemArgument.findItemArgument(service.getItemType(), context)).isPresent()) {
            return this.unwrapIfRequired(this.handleDelete(service, context, maybeItemArgument), context);
        }
        if (methodName.startsWith("query") || methodName.startsWith("findAll") || methodName.startsWith("list") || methodName.startsWith("count") || methodName.startsWith("delete")) {
            QueryArguments partitionAndSort = QueryArguments.create(context, service.getTable().tableSchema().tableMetadata(), service.getItemType());
            if (methodName.startsWith("count")) {
                if (partitionAndSort.isCustomized()) {
                    return this.unwrapIfRequired(service.countUsingQuery(partitionAndSort.generateQuery(context, this.conversionService)), context);
                }
                return this.unwrapIfRequired(service.count(partitionAndSort.getPartitionValue(context.getParameters()), partitionAndSort.getSortValue(context.getParameters())), context);
            }
            if (methodName.startsWith("delete")) {
                if (partitionAndSort.isCustomized()) {
                    return this.unwrapIfRequired(service.deleteAll(service.query(partitionAndSort.generateQuery(context, this.conversionService))), context);
                }
                Optional<ItemArgument> maybeItemArgument2 = ItemArgument.findItemArgument(service.getItemType(), context);
                return this.unwrapIfRequired(this.handleDelete(service, context, maybeItemArgument2), context);
            }
            if (partitionAndSort.isCustomized()) {
                return this.unwrapIfRequired(service.query(partitionAndSort.generateQuery(context, this.conversionService)), context);
            }
            return this.unwrapIfRequired(service.findAll(partitionAndSort.getPartitionValue(context.getParameters()), partitionAndSort.getSortValue(context.getParameters())), context);
        }
        throw new UnsupportedOperationException("Cannot implement method " + context.getExecutableMethod().getTargetMethod());
    }

    private Object unwrapIfRequired(Publisher<?> publisherWithoutCheckpoint, MethodInvocationContext<Object, Object> context) {
        Class type = context.getReturnType().getType();
        Publisher<?> publisher = this.publisherWithCheckpoint(publisherWithoutCheckpoint, context);
        if (Void.TYPE.isAssignableFrom(type) || Void.class.isAssignableFrom(type)) {
            return Mono.from(publisher).block();
        }
        if (Publishers.isConvertibleToPublisher((Class)type)) {
            return Publishers.convertPublisher((ConversionService)this.conversionService, publisher, (Class)type);
        }
        if (Number.class.isAssignableFrom(type) || type.isPrimitive() && !Boolean.TYPE.isAssignableFrom(type)) {
            if (Publishers.isSingle(publisher.getClass())) {
                Object result = Mono.from(publisher).block();
                if (result == null) {
                    return 0;
                }
                return this.conversionService.convert(result, type).orElseGet(() -> {
                    AsyncDynamoDbServiceIntroduction.logTypeConversionFailure(type, result);
                    return 0;
                });
            }
            Long count = (Long)Flux.from(publisher).count().block();
            if (count == null) {
                return 0;
            }
            return this.conversionService.convert((Object)count, type).orElseGet(() -> {
                AsyncDynamoDbServiceIntroduction.logTypeConversionFailure(type, count);
                return 0;
            });
        }
        if (Stream.class.isAssignableFrom(type)) {
            return Flux.from(publisher).toStream();
        }
        if (type.isArray() || Iterable.class.isAssignableFrom(type)) {
            return this.conversionService.convert(Flux.from(publisher).collectList().block(), type).orElse(Collections.emptyList());
        }
        Object value = Mono.from(publisher).block();
        if (value == null) {
            return null;
        }
        return this.conversionService.convert(value, type).orElseGet(() -> {
            AsyncDynamoDbServiceIntroduction.logTypeConversionFailure(type, value);
            return null;
        });
    }

    private <T> Publisher<T> handleSave(AsyncDynamoDbService<T> service, MethodInvocationContext<Object, Object> context) {
        Map params = context.getParameters();
        Argument[] args = context.getArguments();
        if (args.length != 1) {
            throw new UnsupportedOperationException("Method expects 1 parameter - item, iterable of items or array of items");
        }
        Argument itemArgument = args[0];
        Publisher<T> items = this.toPublisher(service.getItemType(), itemArgument, params);
        if (itemArgument.getType().isArray() || Iterable.class.isAssignableFrom(itemArgument.getType()) || Publisher.class.isAssignableFrom(itemArgument.getType())) {
            return service.saveAll(items);
        }
        return service.save(((MutableArgumentValue)params.get(itemArgument.getName())).getValue());
    }

    private <T> Publisher<?> handleDelete(AsyncDynamoDbService<T> service, MethodInvocationContext<Object, Object> context, Optional<ItemArgument> maybeItemArgument) {
        Argument[] args;
        Map params = context.getParameters();
        if (maybeItemArgument.isPresent()) {
            ItemArgument itemArgument = maybeItemArgument.get();
            Publisher<T> items = QueryArguments.toPublisher(this.conversionService, service.getItemType(), itemArgument.getArgument(), params);
            if (!itemArgument.isSingle()) {
                return service.deleteAll(items);
            }
            if (service.getItemType().isAssignableFrom(itemArgument.getArgument().getType())) {
                return Mono.from(items).flatMap(item -> Mono.from(service.delete(item)));
            }
        }
        if ((args = context.getArguments()).length > 2) {
            throw new UnsupportedOperationException("Method expects at most 2 parameters - partition key and sort key, an item or items");
        }
        QueryArguments partitionAndSort = QueryArguments.create(context, service.getTable().tableSchema().tableMetadata(), service.getItemType());
        return service.delete(partitionAndSort.getPartitionValue(params), partitionAndSort.getSortValue(params));
    }

    private <T> Publisher<T> handleGet(AsyncDynamoDbService<T> service, MethodInvocationContext<Object, Object> context) {
        Map params = context.getParameters();
        Argument[] args = context.getArguments();
        if (args.length > 2) {
            throw new UnsupportedOperationException("Method expects at most 2 parameters - partition key and sort key or sort keys");
        }
        QueryArguments partitionAndSort = QueryArguments.create(context, service.getTable().tableSchema().tableMetadata(), service.getItemType());
        Object partitionValue = partitionAndSort.getPartitionValue(params);
        if (!partitionAndSort.hasSortKey()) {
            if (partitionAndSort.isPartitionKeyPublisherOrIterable()) {
                return service.getAll(partitionAndSort.getPartitionAttributeValues(this.conversionService, params));
            }
            return service.get(partitionValue, null);
        }
        if (partitionAndSort.isSortKeyPublisherOrIterable()) {
            return service.getAll(partitionValue, partitionAndSort.getSortAttributeValues(this.conversionService, params));
        }
        return service.get(partitionValue, partitionAndSort.getSortValue(params));
    }

    private <T> Publisher<T> publisherWithCheckpoint(Publisher<T> publisher, MethodInvocationContext<Object, Object> context) {
        if (publisher instanceof Mono) {
            Mono mono = (Mono)publisher;
            return this.monoWithCheckpoint((Publisher<T>)mono, context);
        }
        if (publisher instanceof Flux) {
            Flux flux = (Flux)publisher;
            return this.fluxWithCheckpoint((Publisher<T>)flux, context);
        }
        return Flux.from(publisher).checkpoint(context.getExecutableMethod().toString(), true);
    }

    private <T> Mono<T> monoWithCheckpoint(Publisher<T> publisher, MethodInvocationContext<Object, Object> context) {
        return Mono.from(publisher).checkpoint(context.getExecutableMethod().toString(), true);
    }

    private <T> Flux<T> fluxWithCheckpoint(Publisher<T> publisher, MethodInvocationContext<Object, Object> context) {
        return Flux.from(publisher).checkpoint(context.getExecutableMethod().toString(), true);
    }
}

