/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AttributeConversionHelper;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.EntityIntrospection;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@Singleton
public class BeanIntrospectionAttributeConversionHelper
implements AttributeConversionHelper {
    @Override
    public <T> Map<String, AttributeValue> convert(MappedTableResource<T> table, Map<String, Object> values) {
        BeanIntrospection introspection = EntityIntrospection.getBeanIntrospection(table);
        Object instance = introspection.instantiate();
        return values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.convert(introspection, table, instance, (String)e.getKey(), e.getValue())));
    }

    private <T> AttributeValue convert(BeanIntrospection<T> introspection, MappedTableResource<T> table, T instance, String key, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof AttributeValue) {
            return (AttributeValue)value;
        }
        BeanProperty p = (BeanProperty)introspection.getProperty(key).orElseThrow(() -> new IllegalArgumentException("Unknown property " + key + " for " + instance));
        p.set(instance, value);
        return table.tableSchema().attributeValue(instance, key);
    }
}

