/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AsyncDynamoDBServiceProvider;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AsyncDynamoDbService;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AttributeConversionHelper;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.DefaultAsyncDynamoDbService;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.TableSchemaCreator;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.events.DynamoDbEvent;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.event.ApplicationEventPublisher;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbAsyncTable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;

@Singleton
public class DefaultAsyncDynamoDBServiceProvider
implements AsyncDynamoDBServiceProvider {
    private final ConcurrentHashMap<String, AsyncDynamoDbService<?>> serviceCache = new ConcurrentHashMap();
    private final DynamoDbEnhancedAsyncClient enhancedClient;
    private final DynamoDbAsyncClient client;
    private final AttributeConversionHelper attributeConversionHelper;
    private final ApplicationEventPublisher publisher;
    private final TableSchemaCreator tableSchemaCreator;
    private final boolean createTables;

    public DefaultAsyncDynamoDBServiceProvider(DynamoDbEnhancedAsyncClient enhancedClient, DynamoDbAsyncClient client, AttributeConversionHelper attributeConversionHelper, ApplicationEventPublisher publisher, TableSchemaCreator tableSchemaCreator, @Value(value="${aws.dynamodb.create-tables:false}") boolean createTables) {
        this.enhancedClient = enhancedClient;
        this.client = client;
        this.attributeConversionHelper = attributeConversionHelper;
        this.publisher = publisher;
        this.tableSchemaCreator = tableSchemaCreator;
        this.createTables = createTables;
    }

    @Override
    public <T> AsyncDynamoDbService<T> findOrCreate(String tableName, Class<T> type) {
        return this.serviceCache.computeIfAbsent(tableName, t -> {
            DynamoDbAsyncTable table = this.enhancedClient.table(tableName, this.tableSchemaCreator.create(type));
            DefaultAsyncDynamoDbService newService = new DefaultAsyncDynamoDbService(type, this.enhancedClient, this.client, this.attributeConversionHelper, (ApplicationEventPublisher<DynamoDbEvent>)this.publisher, table);
            if (!this.createTables) {
                return newService;
            }
            Mono.fromFuture((CompletableFuture)table.describeTable()).map(Objects::nonNull).onErrorResume(ResourceNotFoundException.class, e -> Mono.from(newService.createTable())).block(Duration.ofSeconds(30L));
            return newService;
        });
    }
}

