/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AsyncDynamoDbService;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AttributeConversionHelper;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.EntityIntrospection;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Projection;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.SecondaryPartitionKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.SecondarySortKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.Builders;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedQuery;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedScan;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedUpdate;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.UpdateBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.events.DynamoDbEvent;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.exception.FailedBatchRequestException;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbAsyncTable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedAsyncClient;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSecondaryPartitionKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSecondarySortKey;
import software.amazon.awssdk.enhanced.dynamodb.model.BatchWriteResult;
import software.amazon.awssdk.enhanced.dynamodb.model.EnhancedGlobalSecondaryIndex;
import software.amazon.awssdk.enhanced.dynamodb.model.EnhancedLocalSecondaryIndex;
import software.amazon.awssdk.enhanced.dynamodb.model.ReadBatch;
import software.amazon.awssdk.enhanced.dynamodb.model.WriteBatch;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;

public class DefaultAsyncDynamoDbService<T>
implements AsyncDynamoDbService<T> {
    private static final int BATCH_SIZE = 25;
    private final Class<T> itemType;
    private final DynamoDbEnhancedAsyncClient enhancedClient;
    private final DynamoDbAsyncClient client;
    private final AttributeConversionHelper attributeConversionHelper;
    private final ApplicationEventPublisher<DynamoDbEvent> publisher;
    private final DynamoDbAsyncTable<T> table;

    public DefaultAsyncDynamoDbService(Class<T> itemType, DynamoDbEnhancedAsyncClient enhancedClient, DynamoDbAsyncClient client, AttributeConversionHelper attributeConversionHelper, ApplicationEventPublisher<DynamoDbEvent> publisher, DynamoDbAsyncTable<T> table) {
        this.itemType = itemType;
        this.enhancedClient = enhancedClient;
        this.client = client;
        this.attributeConversionHelper = attributeConversionHelper;
        this.publisher = publisher;
        this.table = table;
    }

    @Override
    public Class<T> getItemType() {
        return this.itemType;
    }

    @Override
    public DynamoDbAsyncTable<T> getTable() {
        return this.table;
    }

    @Override
    public Publisher<T> query(DetachedQuery<T> query) {
        return Flux.from(query.query(this.table, this.attributeConversionHelper)).map(this::postLoad);
    }

    @Override
    public Publisher<T> scan(DetachedScan<T> scan) {
        return Flux.from(scan.scan(this.table, this.attributeConversionHelper)).map(this::postLoad);
    }

    @Override
    public Publisher<T> findAll(Object partitionKey, Object sortKey) {
        return Flux.from(this.simplePartitionAndSort(partitionKey, sortKey).query(this.table, this.attributeConversionHelper)).map(this::postLoad);
    }

    @Override
    public <R> Publisher<R> update(DetachedUpdate<T, R> update) {
        return update.update(this.table, this.client, this.attributeConversionHelper, this.publisher);
    }

    @Override
    public <R> Publisher<R> updateAll(Publisher<T> items, UpdateBuilder<T, R> update) {
        BeanIntrospection<T> introspection = EntityIntrospection.getBeanIntrospection(this.table);
        TableMetadata tableMetadata = this.table.tableSchema().tableMetadata();
        return Flux.from(items).map(this::postLoad).flatMap(entity -> {
            introspection.getProperty(tableMetadata.primaryPartitionKey()).ifPresent(p -> update.partitionKey(p.get(entity)));
            tableMetadata.primarySortKey().flatMap(arg_0 -> ((BeanIntrospection)introspection).getProperty(arg_0)).ifPresent(p -> update.sortKey(p.get(entity)));
            return update.update(this.table, this.client, this.attributeConversionHelper, this.publisher);
        });
    }

    @Override
    public Publisher<T> save(T entity) {
        this.publisher.publishEvent(DynamoDbEvent.prePersist(entity));
        return Mono.fromFuture((CompletableFuture)this.table.updateItem(entity)).flatMap(updated -> Mono.fromCallable(() -> {
            this.publisher.publishEvent(DynamoDbEvent.postPersist(updated));
            return updated;
        }));
    }

    @Override
    public Publisher<T> saveAll(Publisher<T> itemsToSave) {
        return Flux.from(itemsToSave).buffer(25).flatMap(batchItems -> Mono.fromFuture((CompletableFuture)this.enhancedClient.batchWriteItem(b -> {
            List<WriteBatch> writeBatches = batchItems.stream().map(i -> {
                this.publisher.publishEvent(DynamoDbEvent.prePersist(i));
                return WriteBatch.builder((Class)this.table.tableSchema().itemType().rawClass()).mappedTableResource(this.table).addPutItem(i).build();
            }).toList();
            b.writeBatches(writeBatches);
        })).zipWith(Mono.just((Object)batchItems))).flatMap(r -> {
            List unprocesseded = ((BatchWriteResult)r.getT1()).unprocessedPutItemsForTable(this.table);
            if (unprocesseded.isEmpty()) {
                return Flux.fromIterable((Iterable)((Iterable)r.getT2())).doOnNext(i -> this.publisher.publishEvent(DynamoDbEvent.postPersist(i)));
            }
            return Flux.error((Throwable)new FailedBatchRequestException("Failed to save items", unprocesseded));
        });
    }

    @Override
    public Publisher<T> delete(Object partitionKey, @Nullable Object sortKey) {
        return this.doWithKey(partitionKey, sortKey, this::delete);
    }

    @Override
    public Publisher<T> delete(T item) {
        this.publisher.publishEvent(DynamoDbEvent.preRemove(item));
        return Mono.fromFuture((CompletableFuture)this.table.deleteItem(this.table.keyFrom(item))).map(deletedItem -> {
            this.publisher.publishEvent(DynamoDbEvent.postRemove(deletedItem));
            return deletedItem;
        });
    }

    @Override
    public Publisher<T> delete(Key key) {
        Object item = this.table.tableSchema().mapToItem(key.primaryKeyMap(this.table.tableSchema()));
        this.publisher.publishEvent(DynamoDbEvent.preRemove(item));
        return Mono.fromFuture((CompletableFuture)this.table.deleteItem(key)).map(deletedItem -> {
            this.publisher.publishEvent(DynamoDbEvent.postRemove(deletedItem));
            return deletedItem;
        });
    }

    @Override
    public Publisher<T> deleteAll(Publisher<T> items) {
        TableSchema tableSchema = this.table.tableSchema();
        return Flux.from(items).buffer(25).flatMap(batchItems -> Mono.fromFuture((CompletableFuture)this.enhancedClient.batchWriteItem(b -> {
            List<WriteBatch> writeBatches = batchItems.stream().map(i -> {
                this.publisher.publishEvent(DynamoDbEvent.preRemove(i));
                return WriteBatch.builder((Class)this.table.tableSchema().itemType().rawClass()).mappedTableResource(this.table).addDeleteItem(i).build();
            }).toList();
            b.writeBatches(writeBatches);
        })).zipWith(Mono.just((Object)batchItems))).flatMap(r -> {
            List unprocesseded = ((BatchWriteResult)r.getT1()).unprocessedDeleteItemsForTable(this.table);
            if (unprocesseded.isEmpty()) {
                ((List)r.getT2()).forEach(i -> this.publisher.publishEvent(DynamoDbEvent.postRemove(i)));
                return Flux.fromIterable((Iterable)((Iterable)r.getT2()));
            }
            return Flux.error((Throwable)new FailedBatchRequestException("Failed to delete items", unprocesseded));
        });
    }

    @Override
    public Publisher<T> get(Object partitionKey, Object sortKey) {
        return this.doWithKey(partitionKey, sortKey, this::get);
    }

    @Override
    public Publisher<T> getAll(Object partitionKey, Publisher<?> sortKeys) {
        return this.doWithKeys(partitionKey, sortKeys, this::getAll);
    }

    @Override
    public Publisher<T> getAll(Publisher<?> partitionKeys) {
        return this.doWithKeys(partitionKeys, this::getAllByAttributeValue);
    }

    @Override
    public Publisher<T> get(Key key) {
        return Mono.fromFuture((CompletableFuture)this.table.getItem(key)).map(this::postLoad);
    }

    @Override
    public Publisher<Long> count(DetachedQuery<T> query) {
        return query.count(this.table, this.attributeConversionHelper);
    }

    @Override
    public Publisher<Long> count(DetachedScan<T> scan) {
        return scan.count(this.table, this.attributeConversionHelper);
    }

    @Override
    public Publisher<Long> count(Object partitionKey, @Nullable Object sortKey) {
        return this.count(this.simplePartitionAndSort(partitionKey, sortKey));
    }

    @Override
    public Publisher<Boolean> createTable() {
        Map<String, ProjectionType> types = this.getProjectionTypes();
        TableMetadata tableMetadata = this.table.tableSchema().tableMetadata();
        return Mono.fromFuture((CompletableFuture)this.table.createTable(b -> {
            ArrayList localSecondaryIndices = new ArrayList();
            ArrayList globalSecondaryIndices = new ArrayList();
            tableMetadata.indices().forEach(i -> {
                if (TableMetadata.primaryIndexName().equals(i.name())) {
                    return;
                }
                ProjectionType type = types.getOrDefault(i.name(), ProjectionType.KEYS_ONLY);
                if (tableMetadata.primaryPartitionKey().equals(tableMetadata.indexPartitionKey(i.name()))) {
                    localSecondaryIndices.add(EnhancedLocalSecondaryIndex.create((String)i.name(), (software.amazon.awssdk.services.dynamodb.model.Projection)((software.amazon.awssdk.services.dynamodb.model.Projection)software.amazon.awssdk.services.dynamodb.model.Projection.builder().projectionType(type).build())));
                } else {
                    globalSecondaryIndices.add(EnhancedGlobalSecondaryIndex.builder().indexName(i.name()).projection((software.amazon.awssdk.services.dynamodb.model.Projection)software.amazon.awssdk.services.dynamodb.model.Projection.builder().projectionType(type).build()).build());
                }
            });
            if (!localSecondaryIndices.isEmpty()) {
                b.localSecondaryIndices(localSecondaryIndices);
            }
            if (!globalSecondaryIndices.isEmpty()) {
                b.globalSecondaryIndices(globalSecondaryIndices);
            }
        })).then(Mono.just((Object)true)).onErrorReturn((Object)false);
    }

    private DetachedQuery<T> simplePartitionAndSort(Object partitionKey, Object sortKey) {
        return this.doWithKey(partitionKey, sortKey, key -> {
            if (key.sortKeyValue().isPresent()) {
                return Builders.query(q -> q.partitionKey(key.partitionKeyValue()).sortKey(s -> s.eq(key.sortKeyValue().get())));
            }
            return Builders.query(q -> q.partitionKey(key.partitionKeyValue()));
        });
    }

    private Publisher<T> getAllByAttributeValue(Publisher<AttributeValue> partitionKeys) {
        TableSchema tableSchema = this.table.tableSchema();
        ConcurrentHashMap order = new ConcurrentHashMap();
        AtomicInteger counter = new AtomicInteger();
        Comparator<Object> comparator = Comparator.comparingInt(i -> order.getOrDefault(tableSchema.attributeValue(i, tableSchema.tableMetadata().primaryPartitionKey()), 0));
        return Flux.from(partitionKeys).buffer(25).map(batchRangeKeys -> this.enhancedClient.batchGetItem(b -> b.readBatches(batchRangeKeys.stream().map(k -> {
            order.put(k, counter.getAndIncrement());
            return ReadBatch.builder((Class)tableSchema.itemType().rawClass()).mappedTableResource(this.table).addGetItem(Key.builder().partitionValue(k).build()).build();
        }).toList()))).flatMap(r -> Flux.from((Publisher)r.resultsForTable(this.table)).map(this::postLoad)).sort(comparator);
    }

    private Publisher<T> getAll(AttributeValue hashKey, Publisher<AttributeValue> rangeKeys) {
        TableSchema tableSchema = this.table.tableSchema();
        ConcurrentHashMap order = new ConcurrentHashMap();
        AtomicInteger counter = new AtomicInteger();
        Comparator<Object> comparator = Comparator.comparingInt(i -> order.getOrDefault(tableSchema.attributeValue(i, (String)tableSchema.tableMetadata().primarySortKey().get()), 0));
        return Flux.from(rangeKeys).buffer(25).map(batchRangeKeys -> this.enhancedClient.batchGetItem(b -> b.readBatches(batchRangeKeys.stream().map(k -> {
            order.put(k, counter.getAndIncrement());
            return ReadBatch.builder((Class)tableSchema.itemType().rawClass()).mappedTableResource(this.table).addGetItem(Key.builder().partitionValue(hashKey).sortValue(k).build()).build();
        }).toList()))).flatMap(r -> Flux.from((Publisher)r.resultsForTable(this.table)).map(this::postLoad)).sort(comparator);
    }

    private Map<String, ProjectionType> getProjectionTypes() {
        HashMap<String, ProjectionType> types = new HashMap<String, ProjectionType>();
        BeanIntrospection<T> introspection = EntityIntrospection.getBeanIntrospection(this.table);
        introspection.getBeanProperties().forEach(p -> {
            AnnotationValue projectionAnnotation = p.getAnnotation(Projection.class);
            if (projectionAnnotation == null) {
                return;
            }
            ArrayList<String> indexNames = new ArrayList<String>();
            indexNames.addAll(this.collectIndicesFromAnnotation((BeanProperty<T, Object>)p, (Class<? extends Annotation>)DynamoDbSecondarySortKey.class));
            indexNames.addAll(this.collectIndicesFromAnnotation((BeanProperty<T, Object>)p, (Class<? extends Annotation>)SecondarySortKey.class));
            indexNames.addAll(this.collectIndicesFromAnnotation((BeanProperty<T, Object>)p, (Class<? extends Annotation>)DynamoDbSecondaryPartitionKey.class));
            indexNames.addAll(this.collectIndicesFromAnnotation((BeanProperty<T, Object>)p, (Class<? extends Annotation>)SecondaryPartitionKey.class));
            if (indexNames.isEmpty()) {
                return;
            }
            ProjectionType type = projectionAnnotation.enumValue(ProjectionType.class).orElse(ProjectionType.KEYS_ONLY);
            for (String name : indexNames) {
                types.put(name, type);
            }
        });
        return types;
    }

    private List<String> collectIndicesFromAnnotation(BeanProperty<T, Object> p, Class<? extends Annotation> indexAnnotationClass) {
        return p.findAnnotation(indexAnnotationClass).map(anno -> Arrays.asList(anno.stringValues("indexNames"))).orElse(Collections.emptyList());
    }

    private T postLoad(T i) {
        this.publisher.publishEvent(DynamoDbEvent.postLoad(i));
        return i;
    }

    private <R> R doWithKey(Object partitionKey, Object sortKey, Function<Key, R> function) {
        String hashKeyName = this.table.tableSchema().tableMetadata().primaryPartitionKey();
        if (partitionKey == null) {
            throw new IllegalArgumentException("Partition key " + hashKeyName + " cannot be null");
        }
        AttributeValue partitionKeyValue = this.attributeConversionHelper.convert(this.table, hashKeyName, partitionKey);
        if (sortKey == null) {
            return function.apply(Key.builder().partitionValue(partitionKeyValue).build());
        }
        String rangeKeyName = (String)this.table.tableSchema().tableMetadata().primarySortKey().get();
        AttributeValue sortKeyValue = this.attributeConversionHelper.convert(this.table, rangeKeyName, sortKey);
        return function.apply(Key.builder().partitionValue(partitionKeyValue).sortValue(sortKeyValue).build());
    }

    private <R> Publisher<R> doWithKeys(Object partitionKey, Publisher<?> sortKeys, BiFunction<AttributeValue, Publisher<AttributeValue>, Publisher<R>> function) {
        String hashKeyName = this.table.tableSchema().tableMetadata().primaryPartitionKey();
        if (partitionKey == null) {
            throw new IllegalArgumentException("Partition key " + hashKeyName + " cannot be null");
        }
        AttributeValue partitionKeyValue = this.attributeConversionHelper.convert(this.table, hashKeyName, partitionKey);
        Optional sortKeyName = this.table.tableSchema().tableMetadata().primarySortKey();
        return function.apply(partitionKeyValue, (Publisher<AttributeValue>)Flux.from(sortKeys).map(key -> this.attributeConversionHelper.convert(this.table, (String)sortKeyName.get(), key)));
    }

    private <R> Publisher<R> doWithKeys(Publisher<?> partitionKeys, Function<Publisher<AttributeValue>, Publisher<R>> function) {
        String hashKeyName = this.table.tableSchema().tableMetadata().primaryPartitionKey();
        return function.apply((Publisher<AttributeValue>)Flux.from(partitionKeys).map(key -> this.attributeConversionHelper.convert(this.table, hashKeyName, key)));
    }
}

