/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AttributeConversionHelper;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.DefaultDynamoDbService;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.DynamoDBServiceProvider;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.DynamoDbService;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.TableSchemaCreator;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.event.ApplicationEventPublisher;
import jakarta.inject.Singleton;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;

@Singleton
public class DefaultDynamoDBServiceProvider
implements DynamoDBServiceProvider {
    private final ConcurrentHashMap<String, DynamoDbService<?>> serviceCache = new ConcurrentHashMap();
    private final DynamoDbEnhancedClient enhancedClient;
    private final DynamoDbClient client;
    private final AttributeConversionHelper attributeConversionHelper;
    private final ApplicationEventPublisher publisher;
    private final TableSchemaCreator tableSchemaCreator;
    private final boolean createTables;

    public DefaultDynamoDBServiceProvider(DynamoDbEnhancedClient enhancedClient, DynamoDbClient client, AttributeConversionHelper attributeConversionHelper, ApplicationEventPublisher publisher, TableSchemaCreator tableSchemaCreator, @Value(value="${aws.dynamodb.create-tables:false}") boolean createTables) {
        this.enhancedClient = enhancedClient;
        this.client = client;
        this.attributeConversionHelper = attributeConversionHelper;
        this.publisher = publisher;
        this.tableSchemaCreator = tableSchemaCreator;
        this.createTables = createTables;
    }

    @Override
    public <T> DynamoDbService<T> findOrCreate(String tableName, Class<T> type) {
        return this.serviceCache.computeIfAbsent(tableName, t -> {
            DynamoDbTable table = this.enhancedClient.table(tableName, this.tableSchemaCreator.create(type));
            DefaultDynamoDbService newService = new DefaultDynamoDbService(type, this.enhancedClient, this.client, this.attributeConversionHelper, this.publisher, table);
            if (!this.createTables) {
                return newService;
            }
            try {
                table.describeTable();
            }
            catch (ResourceNotFoundException e) {
                table.createTable();
            }
            return newService;
        });
    }
}

