/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb;

import com.agorapulse.micronaut.amazon.awssdk.core.client.ClientBuilderProvider;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.DynamoDBConfiguration;
import io.micronaut.aws.sdk.v2.service.dynamodb.DynamoDbClientFactory;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Replaces;
import jakarta.inject.Singleton;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

@Factory
public class DynamoDBClientsFactory {
    @Bean(preDestroy="close")
    @Singleton
    @Replaces(bean=DynamoDbClient.class, factory=DynamoDbClientFactory.class)
    public DynamoDbClient dynamoDbClient(DynamoDBConfiguration configuration, AwsCredentialsProvider awsCredentialsProvider, AwsRegionProvider awsRegionProvider, ClientBuilderProvider builderProvider) {
        DynamoDbClientBuilder builder = (DynamoDbClientBuilder)DynamoDbClient.builder().credentialsProvider(awsCredentialsProvider);
        configuration.configure((AwsClientBuilder)builder, awsRegionProvider, builderProvider, Optional.empty());
        return (DynamoDbClient)builder.build();
    }

    @Bean(preDestroy="close")
    @Singleton
    @Replaces(bean=DynamoDbAsyncClient.class, factory=DynamoDbClientFactory.class)
    public DynamoDbAsyncClient dynamoDbAsyncClient(DynamoDBConfiguration configuration, AwsCredentialsProvider awsCredentialsProvider, AwsRegionProvider awsRegionProvider, ClientBuilderProvider builderProvider, Optional<SdkAsyncHttpClient> httpClient) {
        DynamoDbAsyncClientBuilder builder = (DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().credentialsProvider(awsCredentialsProvider);
        configuration.configure((AwsClientBuilder)builder, awsRegionProvider, builderProvider, httpClient);
        return (DynamoDbAsyncClient)builder.build();
    }
}

