/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.Builders;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedQuery;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedScan;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedUpdate;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.QueryBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.ScanBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.UpdateBuilder;
import io.micronaut.core.annotation.Nullable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Key;

public interface DynamoDbService<T> {
    public Class<T> getItemType();

    public DynamoDbTable<T> getTable();

    public Publisher<T> query(DetachedQuery<T> var1);

    default public Publisher<T> query(Consumer<QueryBuilder<T>> query) {
        return this.query(Builders.query(query));
    }

    public Publisher<T> scan(DetachedScan<T> var1);

    default public Publisher<T> scan(Consumer<ScanBuilder<T>> scan) {
        return this.scan(Builders.scan(scan));
    }

    public Publisher<T> findAll(Object var1, @Nullable Object var2);

    default public Publisher<T> findAll(Object partitionKey) {
        return this.findAll(partitionKey, null);
    }

    public <R> R update(DetachedUpdate<T, R> var1);

    default public <R> R update(Function<UpdateBuilder<T, T>, UpdateBuilder<T, R>> update) {
        return this.update(Builders.update(update));
    }

    public int updateAll(Publisher<T> var1, UpdateBuilder<T, ?> var2);

    default public <R> int updateAll(Publisher<T> items, Function<UpdateBuilder<T, T>, UpdateBuilder<T, R>> update) {
        return this.updateAll(items, Builders.update(update));
    }

    public T save(T var1);

    public Publisher<T> saveAll(Publisher<T> var1);

    public T delete(Object var1, @Nullable Object var2);

    public T delete(T var1);

    public T delete(Key var1);

    public int deleteAll(Publisher<T> var1);

    public T get(Object var1, Object var2);

    public Publisher<T> getAll(Object var1, Publisher<?> var2);

    public Publisher<T> getAll(Publisher<?> var1);

    public T get(Key var1);

    public int count(DetachedQuery<T> var1);

    default public int countUsingQuery(Consumer<QueryBuilder<T>> query) {
        return this.count(Builders.query(query));
    }

    public int count(DetachedScan<T> var1);

    default public int countUsingScan(Consumer<ScanBuilder<T>> scan) {
        return this.count(Builders.scan(scan));
    }

    public int count(Object var1, @Nullable Object var2);

    public void createTable();
}

