/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.DynamoDbServiceIntroduction;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Service;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationValue;
import jakarta.inject.Singleton;

@Singleton
@InterceptorBean(value={Service.class})
public class ServiceIntroduction
implements MethodInterceptor<Object, Object> {
    private final DynamoDbServiceIntroduction introduction;

    public ServiceIntroduction(DynamoDbServiceIntroduction introduction) {
        this.introduction = introduction;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        AnnotationValue serviceAnnotationValue = context.getAnnotation(Service.class);
        if (serviceAnnotationValue == null) {
            throw new IllegalStateException("Invocation context is missing required annotation Service");
        }
        return this.doIntercept(context, (AnnotationValue<Service>)serviceAnnotationValue);
    }

    private <T> Object doIntercept(MethodInvocationContext<Object, Object> context, AnnotationValue<Service> serviceAnnotationValue) {
        Class type = (Class)serviceAnnotationValue.classValue().orElseThrow(() -> new IllegalArgumentException("Annotation is missing the type value!"));
        String tableName = serviceAnnotationValue.stringValue("tableName").orElseGet(type::getSimpleName);
        return this.introduction.doIntercept(context, type, tableName);
    }
}

