/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DefaultQueryBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DefaultScanBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DefaultUpdateBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.QueryBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.ScanBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.UpdateBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.ScanEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;

public class Builders {
    private static final int DEFAULT_QUERY_LIMIT = 20;
    public static final Sort asc = Sort.ASC;
    public static final Sort desc = Sort.DESC;
    public static final Read read = Read.READ;
    public static final ReturnValue none = ReturnValue.NONE;
    public static final ReturnValue allOld = ReturnValue.ALL_OLD;
    public static final ReturnValue updatedOld = ReturnValue.UPDATED_OLD;
    public static final ReturnValue allNew = ReturnValue.ALL_NEW;
    public static final ReturnValue updatedNew = ReturnValue.UPDATED_NEW;

    @Deprecated
    public static <T> QueryBuilder<T> query(Class<T> type) {
        return Builders.query();
    }

    public static <T> QueryBuilder<T> query() {
        return new DefaultQueryBuilder(QueryEnhancedRequest.builder().limit(Integer.valueOf(20)));
    }

    @Deprecated
    public static <T> QueryBuilder<T> query(Class<T> type, Consumer<QueryBuilder<T>> definition) {
        return Builders.query(definition);
    }

    public static <T> QueryBuilder<T> query(Consumer<QueryBuilder<T>> definition) {
        QueryBuilder<T> builder = Builders.query();
        definition.accept(builder);
        return builder;
    }

    @Deprecated
    public static <T> ScanBuilder<T> scan(Class<T> type) {
        return Builders.scan();
    }

    public static <T> ScanBuilder<T> scan() {
        return new DefaultScanBuilder(ScanEnhancedRequest.builder().limit(Integer.valueOf(20)));
    }

    @Deprecated
    public static <T> ScanBuilder<T> scan(Class<T> type, Consumer<ScanBuilder<T>> definition) {
        return Builders.scan(definition);
    }

    public static <T> ScanBuilder<T> scan(Consumer<ScanBuilder<T>> definition) {
        ScanBuilder<T> builder = Builders.scan();
        definition.accept(builder);
        return builder;
    }

    @Deprecated
    public static <T> UpdateBuilder<T, T> update(Class<T> type) {
        return Builders.update();
    }

    public static <T> UpdateBuilder<T, T> update() {
        return new DefaultUpdateBuilder();
    }

    @Deprecated
    public static <T, R> UpdateBuilder<T, R> update(Class<T> type, Function<UpdateBuilder<T, T>, UpdateBuilder<T, R>> definition) {
        return Builders.update(definition);
    }

    public static <T, R> UpdateBuilder<T, R> update(Function<UpdateBuilder<T, T>, UpdateBuilder<T, R>> definition) {
        UpdateBuilder<T, T> builder = Builders.update();
        return definition.apply(builder);
    }

    public static enum Sort {
        ASC,
        DESC;

    }

    public static enum Read {
        READ;

    }
}

