/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AttributeConversionHelper;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.FilterConditionCollector;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.QueryConditionalFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

final class DefaultFilterConditionCollector<T>
implements FilterConditionCollector<T> {
    private final MappedTableResource<T> table;
    private final AttributeConversionHelper attributeConversionHelper;
    private List<QueryConditional> conditions = new LinkedList<QueryConditional>();

    DefaultFilterConditionCollector(MappedTableResource<T> table, AttributeConversionHelper attributeConversionHelper) {
        this.table = table;
        this.attributeConversionHelper = attributeConversionHelper;
    }

    @Override
    public DefaultFilterConditionCollector<T> inList(String attributeOrIndex, Object ... values) {
        return this.inList(attributeOrIndex, Arrays.asList(values));
    }

    @Override
    public DefaultFilterConditionCollector<T> inList(String attributeOrIndex, Collection<?> values) {
        List<AttributeValue> valuesAttributes = values.stream().map(value -> this.attributeConversionHelper.convert(this.table, attributeOrIndex, value)).collect(Collectors.toList());
        this.conditions.add(QueryConditionalFactory.inList(attributeOrIndex, valuesAttributes));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> eq(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.equalTo(attributeOrIndex, this.attributeConversionHelper.convert(this.table, attributeOrIndex, value)));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> ne(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.notEqualTo(attributeOrIndex, this.attributeConversionHelper.convert(this.table, attributeOrIndex, value)));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> le(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.lessThanOrEqualTo(attributeOrIndex, this.attributeConversionHelper.convert(this.table, attributeOrIndex, value)));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> lt(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.lessThan(attributeOrIndex, this.attributeConversionHelper.convert(this.table, attributeOrIndex, value)));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> ge(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.greaterThanOrEqualTo(attributeOrIndex, this.attributeConversionHelper.convert(this.table, attributeOrIndex, value)));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> gt(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.greaterThan(attributeOrIndex, this.attributeConversionHelper.convert(this.table, attributeOrIndex, value)));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> sizeEq(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.sizeEqualTo(attributeOrIndex, AttributeValues.numberValue((Number)((Number)value))));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> sizeNe(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.sizeNotEqualTo(attributeOrIndex, AttributeValues.numberValue((Number)((Number)value))));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> sizeLe(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.sizeLessThanOrEqualTo(attributeOrIndex, AttributeValues.numberValue((Number)((Number)value))));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> sizeLt(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.sizeLessThan(attributeOrIndex, AttributeValues.numberValue((Number)((Number)value))));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> sizeGe(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.sizeGreaterThanOrEqualTo(attributeOrIndex, AttributeValues.numberValue((Number)((Number)value))));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> sizeGt(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.sizeGreaterThan(attributeOrIndex, AttributeValues.numberValue((Number)((Number)value))));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> between(String attributeOrIndex, Object lo, Object hi) {
        this.conditions.add(QueryConditionalFactory.between(attributeOrIndex, this.attributeConversionHelper.convert(this.table, attributeOrIndex, lo), this.attributeConversionHelper.convert(this.table, attributeOrIndex, hi)));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> notExists(String attributeOrIndex) {
        this.conditions.add(QueryConditionalFactory.attributeNotExists(attributeOrIndex));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> isNull(String attributeOrIndex) {
        this.conditions.add(QueryConditionalFactory.not(QueryConditionalFactory.attributeExists(attributeOrIndex)));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> contains(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.contains(attributeOrIndex, this.attributeConversionHelper.convert(this.table, attributeOrIndex, value)));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> notContains(String attributeOrIndex, Object value) {
        this.conditions.add(QueryConditionalFactory.not(QueryConditionalFactory.contains(attributeOrIndex, this.attributeConversionHelper.convert(this.table, attributeOrIndex, value))));
        return this;
    }

    @Override
    public FilterConditionCollector<T> typeOf(String attributeOrIndex, Class<?> type) {
        this.conditions.add(QueryConditionalFactory.attributeType(attributeOrIndex, type));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> beginsWith(String attributeOrIndex, String value) {
        this.conditions.add(QueryConditionalFactory.beginsWith(attributeOrIndex, value));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> group(Consumer<FilterConditionCollector<T>> conditions) {
        DefaultFilterConditionCollector<T> nested = new DefaultFilterConditionCollector<T>(this.table, this.attributeConversionHelper);
        conditions.accept(nested);
        this.conditions.add(QueryConditionalFactory.group(QueryConditionalFactory.and(nested.conditions)));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> or(Consumer<FilterConditionCollector<T>> conditions) {
        DefaultFilterConditionCollector<T> nested = new DefaultFilterConditionCollector<T>(this.table, this.attributeConversionHelper);
        conditions.accept(nested);
        this.conditions.add(QueryConditionalFactory.or(nested.conditions));
        return this;
    }

    @Override
    public DefaultFilterConditionCollector<T> and(Consumer<FilterConditionCollector<T>> conditions) {
        DefaultFilterConditionCollector<T> nested = new DefaultFilterConditionCollector<T>(this.table, this.attributeConversionHelper);
        conditions.accept(nested);
        this.conditions.add(QueryConditionalFactory.and(nested.conditions));
        return this;
    }

    public QueryConditional getCondition() {
        return QueryConditionalFactory.and(this.conditions);
    }
}

