/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AttributeConversionHelper;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.KeyConditionCollector;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.QueryConditionalFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;

final class DefaultKeyConditionCollector<T>
implements KeyConditionCollector<T> {
    private final MappedTableResource<T> table;
    private final AttributeConversionHelper attributeConversionHelper;
    private final String index;
    private List<QueryConditional> conditions = new LinkedList<QueryConditional>();

    public DefaultKeyConditionCollector(MappedTableResource<T> table, AttributeConversionHelper attributeConversionHelper, String index) {
        this.table = table;
        this.attributeConversionHelper = attributeConversionHelper;
        this.index = index;
    }

    @Override
    public DefaultKeyConditionCollector<T> eq(Object value) {
        this.conditions.add(QueryConditionalFactory.equalTo(this.getSortKey(), this.attributeConversionHelper.convert(this.table, this.getSortKey(), value)));
        return this;
    }

    @Override
    public DefaultKeyConditionCollector<T> le(Object value) {
        this.conditions.add(QueryConditionalFactory.lessThanOrEqualTo(this.getSortKey(), this.attributeConversionHelper.convert(this.table, this.getSortKey(), value)));
        return this;
    }

    @Override
    public DefaultKeyConditionCollector<T> lt(Object value) {
        this.conditions.add(QueryConditionalFactory.lessThan(this.getSortKey(), this.attributeConversionHelper.convert(this.table, this.getSortKey(), value)));
        return this;
    }

    @Override
    public DefaultKeyConditionCollector<T> ge(Object value) {
        this.conditions.add(QueryConditionalFactory.greaterThanOrEqualTo(this.getSortKey(), this.attributeConversionHelper.convert(this.table, this.getSortKey(), value)));
        return this;
    }

    @Override
    public DefaultKeyConditionCollector<T> gt(Object value) {
        this.conditions.add(QueryConditionalFactory.greaterThan(this.getSortKey(), this.attributeConversionHelper.convert(this.table, this.getSortKey(), value)));
        return this;
    }

    @Override
    public DefaultKeyConditionCollector<T> between(Object lo, Object hi) {
        this.conditions.add(QueryConditionalFactory.between(this.getSortKey(), this.attributeConversionHelper.convert(this.table, this.getSortKey(), lo), this.attributeConversionHelper.convert(this.table, this.getSortKey(), hi)));
        return this;
    }

    @Override
    public DefaultKeyConditionCollector<T> beginsWith(String value) {
        this.conditions.add(QueryConditionalFactory.beginsWith(this.getSortKey(), value));
        return this;
    }

    public QueryConditional getCondition() {
        return QueryConditionalFactory.and(this.conditions);
    }

    String getSortKey() {
        Optional sortKey = this.table.tableSchema().tableMetadata().indexSortKey(this.index);
        if (!sortKey.isPresent()) {
            throw new IllegalStateException("Sort key not defined for " + this.table.tableSchema().itemType() + " and index " + this.index);
        }
        return (String)sortKey.get();
    }
}

