/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AttributeConversionHelper;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.Builders;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DefaultFilterConditionCollector;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DefaultKeyConditionCollector;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.FilterConditionCollector;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.KeyConditionCollector;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.QueryBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.QueryConditionalFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbAsyncTable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.PageIterable;
import software.amazon.awssdk.enhanced.dynamodb.model.PagePublisher;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

class DefaultQueryBuilder<T>
implements QueryBuilder<T> {
    private final QueryEnhancedRequest.Builder __expression;
    private final List<Consumer<FilterConditionCollector<T>>> __filterCollectorsConsumers = new LinkedList<Consumer<FilterConditionCollector<T>>>();
    private final List<Consumer<KeyConditionCollector<T>>> __queryConditionals = new LinkedList<Consumer<KeyConditionCollector<T>>>();
    private String __index = TableMetadata.primaryIndexName();
    private Object __hash;
    private Object __lastEvaluatedKey;
    private int __max = Integer.MAX_VALUE;
    private Consumer<QueryEnhancedRequest.Builder> __configurer = b -> {};

    DefaultQueryBuilder(QueryEnhancedRequest.Builder expression) {
        this.__expression = expression;
    }

    @Override
    public DefaultQueryBuilder<T> order(Builders.Sort sort) {
        if (sort == Builders.Sort.ASC) {
            this.__expression.scanIndexForward(Boolean.valueOf(true));
        } else if (sort == Builders.Sort.DESC) {
            this.__expression.scanIndexForward(Boolean.valueOf(false));
        }
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> inconsistent(Builders.Read read) {
        if (read == Builders.Read.READ) {
            this.__expression.consistentRead(Boolean.valueOf(false));
        }
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> consistent(Builders.Read read) {
        if (read == Builders.Read.READ) {
            this.__expression.consistentRead(Boolean.valueOf(true));
        }
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> index(String name) {
        this.__index = name;
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> partitionKey(Object hash) {
        this.__hash = hash;
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> sortKey(Consumer<KeyConditionCollector<T>> conditions) {
        this.__queryConditionals.add(conditions);
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> filter(Consumer<FilterConditionCollector<T>> conditions) {
        this.__filterCollectorsConsumers.add(conditions);
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> page(int page) {
        this.__expression.limit(Integer.valueOf(page));
        return this;
    }

    @Override
    public QueryBuilder<T> limit(int max) {
        this.__max = max;
        return this;
    }

    @Override
    public QueryBuilder<T> lastEvaluatedKey(Object lastEvaluatedKey) {
        this.__lastEvaluatedKey = lastEvaluatedKey;
        return this;
    }

    @Override
    public int count(DynamoDbTable<T> mapper, AttributeConversionHelper attributeConversionHelper) {
        return Flux.from(this.query(mapper, attributeConversionHelper)).count().blockOptional().map(Long::intValue).orElse(0);
    }

    public Mono<Long> count(DynamoDbAsyncTable<T> mapper, AttributeConversionHelper attributeConversionHelper) {
        return this.query(mapper, attributeConversionHelper).count();
    }

    @Override
    public Flux<T> query(DynamoDbTable<T> mapper, AttributeConversionHelper attributeConversionHelper) {
        QueryEnhancedRequest request = this.resolveRequest((MappedTableResource<T>)mapper, attributeConversionHelper);
        PageIterable iterable = this.__index == null ? mapper.query(request) : mapper.index(this.__index).query(request);
        Flux results = Flux.fromIterable((Iterable)iterable).flatMap(p -> Flux.fromIterable((Iterable)p.items()));
        if (this.__max < Integer.MAX_VALUE) {
            return results.take((long)this.__max);
        }
        return results;
    }

    @Override
    public QueryEnhancedRequest resolveRequest(MappedTableResource<T> mapper, AttributeConversionHelper attributeConversionHelper) {
        this.applyRangeConditions(mapper, attributeConversionHelper, arg_0 -> ((QueryEnhancedRequest.Builder)this.__expression).queryConditional(arg_0));
        String currentIndex = this.__index == null ? TableMetadata.primaryIndexName() : this.__index;
        this.applyFilterConditions(mapper, attributeConversionHelper, cond -> this.__expression.filterExpression(cond.expression(mapper.tableSchema(), currentIndex)));
        this.applyLastEvaluatedKey(this.__expression, mapper);
        this.__configurer.accept(this.__expression);
        return this.__expression.build();
    }

    @Override
    public Flux<T> query(DynamoDbAsyncTable<T> mapper, AttributeConversionHelper attributeConversionHelper) {
        QueryEnhancedRequest request = this.resolveRequest((MappedTableResource<T>)mapper, attributeConversionHelper);
        PagePublisher iterable = this.__index == null ? mapper.query(request) : mapper.index(this.__index).query(request);
        Flux results = Flux.from((Publisher)iterable).flatMap(p -> Flux.fromIterable((Iterable)p.items()));
        if (this.__max < Integer.MAX_VALUE) {
            return results.take((long)this.__max);
        }
        return results;
    }

    @Override
    public QueryBuilder<T> only(Collection<String> propertyPaths) {
        this.__expression.attributesToProject(propertyPaths);
        return this;
    }

    @Override
    public QueryBuilder<T> configure(Consumer<QueryEnhancedRequest.Builder> configurer) {
        this.__configurer = configurer;
        return this;
    }

    private void applyRangeConditions(MappedTableResource<T> model, AttributeConversionHelper attributeConversionHelper, Consumer<QueryConditional> addFilterConsumer) {
        DefaultKeyConditionCollector<T> rangeCollector = new DefaultKeyConditionCollector<T>(model, attributeConversionHelper, this.__index);
        if (!this.__queryConditionals.isEmpty()) {
            for (Consumer<KeyConditionCollector<DefaultKeyConditionCollector<T>>> consumer : this.__queryConditionals) {
                consumer.accept(rangeCollector);
            }
        }
        String partitionKey = model.tableSchema().tableMetadata().indexPartitionKey(this.__index);
        QueryConditional queryConditional = QueryConditionalFactory.equalTo(partitionKey, attributeConversionHelper.convert(model, partitionKey, this.__hash));
        addFilterConsumer.accept(QueryConditionalFactory.and(queryConditional, rangeCollector.getCondition()));
    }

    private void applyFilterConditions(MappedTableResource<T> model, AttributeConversionHelper attributeConversionHelper, Consumer<QueryConditional> addFilterConsumer) {
        if (!this.__filterCollectorsConsumers.isEmpty()) {
            DefaultFilterConditionCollector<T> filterCollector = new DefaultFilterConditionCollector<T>(model, attributeConversionHelper);
            for (Consumer<FilterConditionCollector<DefaultFilterConditionCollector<T>>> consumer : this.__filterCollectorsConsumers) {
                consumer.accept(filterCollector);
            }
            addFilterConsumer.accept(filterCollector.getCondition());
        }
    }

    private void applyLastEvaluatedKey(QueryEnhancedRequest.Builder exp, MappedTableResource<T> mapper) {
        if (this.__lastEvaluatedKey == null) {
            return;
        }
        TableSchema schema = mapper.tableSchema();
        Map<String, Object> key = this.__lastEvaluatedKey instanceof Map ? (Map<String, AttributeValue>)this.__lastEvaluatedKey : schema.itemToMap(this.__lastEvaluatedKey, true);
        HashSet indexKeys = new HashSet(schema.tableMetadata().primaryKeys());
        if (this.__index != null) {
            indexKeys.addAll(schema.tableMetadata().indexKeys(this.__index));
        }
        key = key.entrySet().stream().filter((? super T e) -> indexKeys.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        exp.exclusiveStartKey(key);
    }
}

