/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AttributeConversionHelper;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.Builders;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DefaultFilterConditionCollector;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.FilterConditionCollector;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.ScanBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbAsyncTable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.PageIterable;
import software.amazon.awssdk.enhanced.dynamodb.model.PagePublisher;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.enhanced.dynamodb.model.ScanEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

class DefaultScanBuilder<T>
implements ScanBuilder<T> {
    private final ScanEnhancedRequest.Builder __expression;
    private final List<Consumer<FilterConditionCollector<T>>> __filterCollectorsConsumers = new LinkedList<Consumer<FilterConditionCollector<T>>>();
    private String __index = TableMetadata.primaryIndexName();
    private Object __lastEvaluatedKey;
    private int __max = Integer.MAX_VALUE;
    private Consumer<ScanEnhancedRequest.Builder> __configurer = b -> {};

    DefaultScanBuilder(ScanEnhancedRequest.Builder expression) {
        this.__expression = expression;
    }

    @Override
    public DefaultScanBuilder<T> inconsistent(Builders.Read read) {
        if (read == Builders.Read.READ) {
            this.__expression.consistentRead(Boolean.valueOf(false));
        }
        return this;
    }

    @Override
    public DefaultScanBuilder<T> consistent(Builders.Read read) {
        if (read == Builders.Read.READ) {
            this.__expression.consistentRead(Boolean.valueOf(true));
        }
        return this;
    }

    @Override
    public DefaultScanBuilder<T> index(String name) {
        this.__index = name;
        return this;
    }

    @Override
    public DefaultScanBuilder<T> filter(Consumer<FilterConditionCollector<T>> conditions) {
        this.__filterCollectorsConsumers.add(conditions);
        return this;
    }

    @Override
    public DefaultScanBuilder<T> page(int page) {
        this.__expression.limit(Integer.valueOf(page));
        return this;
    }

    @Override
    public DefaultScanBuilder<T> limit(int max) {
        this.__max = max;
        return this;
    }

    @Override
    public DefaultScanBuilder<T> lastEvaluatedKey(Object lastEvaluatedKey) {
        this.__lastEvaluatedKey = lastEvaluatedKey;
        return this;
    }

    @Override
    public int count(DynamoDbTable<T> mapper, AttributeConversionHelper attributeConversionHelper) {
        return Flux.from(this.scan(mapper, attributeConversionHelper)).count().blockOptional().map(Long::intValue).orElse(0);
    }

    public Mono<Long> count(DynamoDbAsyncTable<T> mapper, AttributeConversionHelper attributeConversionHelper) {
        return this.scan(mapper, attributeConversionHelper).count();
    }

    @Override
    public Flux<T> scan(DynamoDbTable<T> mapper, AttributeConversionHelper attributeConversionHelper) {
        ScanEnhancedRequest request = this.resolveRequest((MappedTableResource<T>)mapper, attributeConversionHelper);
        PageIterable iterable = this.__index == null ? mapper.scan(request) : mapper.index(this.__index).scan(request);
        Flux results = Flux.fromIterable((Iterable)iterable).flatMap(p -> Flux.fromIterable((Iterable)p.items()));
        if (this.__max < Integer.MAX_VALUE) {
            return results.take((long)this.__max);
        }
        return results;
    }

    @Override
    public Flux<T> scan(DynamoDbAsyncTable<T> mapper, AttributeConversionHelper attributeConversionHelper) {
        ScanEnhancedRequest request = this.resolveRequest((MappedTableResource<T>)mapper, attributeConversionHelper);
        PagePublisher iterable = this.__index == null ? mapper.scan(request) : mapper.index(this.__index).scan(request);
        Flux results = Flux.from((Publisher)iterable).flatMap(p -> Flux.fromIterable((Iterable)p.items()));
        if (this.__max < Integer.MAX_VALUE) {
            return results.take((long)this.__max);
        }
        return results;
    }

    @Override
    public ScanEnhancedRequest resolveRequest(MappedTableResource<T> mapper, AttributeConversionHelper attributeConversionHelper) {
        String currentIndex = this.__index == null ? TableMetadata.primaryIndexName() : this.__index;
        this.applyConditions(mapper, attributeConversionHelper, this.__filterCollectorsConsumers, cond -> this.__expression.filterExpression(cond.expression(mapper.tableSchema(), currentIndex)));
        this.applyLastEvaluatedKey(this.__expression, mapper);
        this.__configurer.accept(this.__expression);
        return this.__expression.build();
    }

    @Override
    public ScanBuilder<T> only(Collection<String> propertyPaths) {
        this.__expression.attributesToProject(propertyPaths);
        return this;
    }

    @Override
    public ScanBuilder<T> configure(Consumer<ScanEnhancedRequest.Builder> configurer) {
        this.__configurer = configurer;
        return this;
    }

    private void applyConditions(MappedTableResource<T> table, AttributeConversionHelper attributeConversionHelper, List<Consumer<FilterConditionCollector<T>>> filterCollectorsConsumers, Consumer<QueryConditional> addFilterConsumer) {
        if (!filterCollectorsConsumers.isEmpty()) {
            DefaultFilterConditionCollector<T> filterCollector = new DefaultFilterConditionCollector<T>(table, attributeConversionHelper);
            for (Consumer<FilterConditionCollector<DefaultFilterConditionCollector<T>>> consumer : filterCollectorsConsumers) {
                consumer.accept(filterCollector);
            }
            addFilterConsumer.accept(filterCollector.getCondition());
        }
    }

    private void applyLastEvaluatedKey(ScanEnhancedRequest.Builder exp, MappedTableResource<T> mapper) {
        if (this.__lastEvaluatedKey == null) {
            return;
        }
        TableSchema schema = mapper.tableSchema();
        Map<String, Object> key = this.__lastEvaluatedKey instanceof Map ? (Map<String, AttributeValue>)this.__lastEvaluatedKey : schema.itemToMap(this.__lastEvaluatedKey, true);
        HashSet indexKeys = new HashSet(schema.tableMetadata().primaryKeys());
        if (this.__index != null) {
            indexKeys.addAll(schema.tableMetadata().indexKeys(this.__index));
        }
        key = key.entrySet().stream().filter((? super T e) -> indexKeys.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        exp.exclusiveStartKey(key);
    }
}

