/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.AttributeConversionHelper;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.UpdateBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.events.DynamoDbEvent;
import io.micronaut.context.event.ApplicationEventPublisher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbAsyncTable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;

class DefaultUpdateBuilder<T, R>
implements UpdateBuilder<T, R> {
    private final List<Update> __updates = new ArrayList<Update>();
    private ReturnValue __returnValue = ReturnValue.NONE;
    private Function<T, ?> __returnValueMapper = Function.identity();
    private Object __hash;
    private Object __range;
    private Consumer<UpdateItemRequest.Builder> __configurer = u -> {};

    DefaultUpdateBuilder() {
    }

    @Override
    public UpdateBuilder<T, R> partitionKey(Object key) {
        this.__hash = key;
        return this;
    }

    @Override
    public UpdateBuilder<T, R> sortKey(Object key) {
        this.__range = key;
        return this;
    }

    @Override
    public UpdateBuilder<T, R> add(String attributeName, Object delta) {
        this.__updates.add(new Update(attributeName, AttributeAction.ADD, delta));
        return this;
    }

    @Override
    public UpdateBuilder<T, R> put(String attributeName, Object value) {
        this.__updates.add(new Update(attributeName, AttributeAction.PUT, value));
        return this;
    }

    @Override
    public UpdateBuilder<T, R> delete(String attributeName) {
        this.__updates.add(new Update(attributeName, AttributeAction.DELETE, null));
        return this;
    }

    @Override
    public UpdateBuilder<T, R> configure(Consumer<UpdateItemRequest.Builder> configurer) {
        this.__configurer = configurer;
        return this;
    }

    @Override
    public <N> UpdateBuilder<T, N> returns(ReturnValue returnValue, Function<T, N> mapper) {
        this.__returnValue = returnValue;
        this.__returnValueMapper = mapper;
        return this;
    }

    @Override
    public R update(DynamoDbTable<T> mapper, DynamoDbClient client, AttributeConversionHelper attributeConversionHelper, ApplicationEventPublisher publisher) {
        UpdateItemRequest request = this.resolveRequest((MappedTableResource<T>)mapper, attributeConversionHelper);
        Object keyItem = mapper.tableSchema().mapToItem(request.key());
        publisher.publishEvent(DynamoDbEvent.preUpdate(keyItem));
        UpdateItemResponse result = client.updateItem(request);
        Map attributes = result.attributes();
        if (attributes == null || attributes.isEmpty()) {
            return null;
        }
        if (ReturnValue.NONE.equals((Object)this.__returnValue)) {
            return null;
        }
        Object item = mapper.tableSchema().mapToItem(attributes);
        publisher.publishEvent(DynamoDbEvent.postUpdate(item));
        return (R)this.__returnValueMapper.apply(item);
    }

    @Override
    public Publisher<R> update(DynamoDbAsyncTable<T> mapper, DynamoDbAsyncClient client, AttributeConversionHelper attributeConversionHelper, ApplicationEventPublisher publisher) {
        UpdateItemRequest request = this.resolveRequest((MappedTableResource<T>)mapper, attributeConversionHelper);
        Object keyItem = mapper.tableSchema().mapToItem(request.key());
        publisher.publishEvent(DynamoDbEvent.preUpdate(keyItem));
        return Mono.fromFuture((CompletableFuture)client.updateItem(request)).flatMap(result -> {
            if (ReturnValue.NONE.equals((Object)this.__returnValue)) {
                return Mono.just((Object)keyItem);
            }
            Map attributes = result.attributes();
            if (attributes == null || attributes.isEmpty()) {
                return Mono.just((Object)keyItem);
            }
            Object item = mapper.tableSchema().mapToItem(attributes);
            publisher.publishEvent(DynamoDbEvent.postUpdate(item));
            return Mono.just(this.__returnValueMapper.apply(item));
        });
    }

    @Override
    public UpdateItemRequest resolveRequest(MappedTableResource<T> mapper, AttributeConversionHelper attributeConversionHelper) {
        UpdateItemRequest.Builder builder = UpdateItemRequest.builder();
        this.__configurer.accept(builder);
        builder.tableName(mapper.tableName());
        Key.Builder key = Key.builder();
        if (this.__range != null) {
            String sortKey = (String)mapper.tableSchema().tableMetadata().primarySortKey().orElseThrow(() -> new IllegalArgumentException("Range key defined for update but none present on entity " + mapper.tableSchema().itemType().rawClass()));
            key.sortValue(attributeConversionHelper.convert(mapper, sortKey, this.__range));
        }
        if (this.__hash != null) {
            String partitionKey = mapper.tableSchema().tableMetadata().primaryPartitionKey();
            key.partitionValue(attributeConversionHelper.convert(mapper, partitionKey, this.__hash));
        }
        builder.key(key.build().primaryKeyMap(mapper.tableSchema()));
        builder.returnValues(this.__returnValue);
        HashMap<String, AttributeValueUpdate> attributeUpdates = new HashMap<String, AttributeValueUpdate>();
        Map<String, AttributeValue> converted = attributeConversionHelper.convert(mapper, this.__updates.stream().filter(u -> u.value != null).collect(Collectors.toMap(u -> u.name, u -> u.value)));
        for (Update u2 : this.__updates) {
            attributeUpdates.put(u2.name, (AttributeValueUpdate)AttributeValueUpdate.builder().action(u2.action).value(converted.get(u2.name)).build());
        }
        builder.attributeUpdates(attributeUpdates);
        this.__configurer.accept(builder);
        return (UpdateItemRequest)builder.build();
    }

    private static class Update {
        final String name;
        final AttributeAction action;
        final Object value;

        private Update(String name, AttributeAction action, Object value) {
            this.name = name;
            this.action = action;
            this.value = value;
        }
    }
}

