/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.DetachedUpdate;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public interface UpdateBuilder<T, R>
extends DetachedUpdate<T, R> {
    public UpdateBuilder<T, R> partitionKey(Object var1);

    @Deprecated
    default public UpdateBuilder<T, R> hash(Object key) {
        return this.partitionKey(key);
    }

    public UpdateBuilder<T, R> sortKey(Object var1);

    @Deprecated
    default public UpdateBuilder<T, R> range(Object key) {
        return this.sortKey(key);
    }

    public UpdateBuilder<T, R> add(String var1, Object var2);

    public UpdateBuilder<T, R> put(String var1, Object var2);

    public UpdateBuilder<T, R> delete(String var1);

    public <N> UpdateBuilder<T, N> returns(ReturnValue var1, Function<T, N> var2);

    default public UpdateBuilder<T, T> returns(ReturnValue returnValue) {
        return this.returns(returnValue, Function.identity());
    }

    default public UpdateBuilder<T, Void> returnNone() {
        return this.returns(ReturnValue.NONE, i -> null);
    }

    default public <N> UpdateBuilder<T, N> returnAllOld(Function<T, N> mapper) {
        return this.returns(ReturnValue.ALL_OLD, mapper);
    }

    default public <N> UpdateBuilder<T, N> returnUpdatedOld(Function<T, N> mapper) {
        return this.returns(ReturnValue.UPDATED_OLD, mapper);
    }

    default public <N> UpdateBuilder<T, N> returnAllNew(Function<T, N> mapper) {
        return this.returns(ReturnValue.ALL_NEW, mapper);
    }

    default public <N> UpdateBuilder<T, N> returnUpdatedNew(Function<T, N> mapper) {
        return this.returns(ReturnValue.UPDATED_NEW, mapper);
    }

    public UpdateBuilder<T, R> configure(Consumer<UpdateItemRequest.Builder> var1);
}

