/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.QueryConditionalFactory;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

class ConditionalWithConditionalAndArgument
implements QueryConditional {
    private final String template;
    private final QueryConditional first;
    private final AttributeValue value;

    ConditionalWithConditionalAndArgument(String template, QueryConditional first, AttributeValue value) {
        this.template = template;
        this.first = first;
        this.value = value;
    }

    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        Expression ex = this.first.expression(tableSchema, indexName);
        String propertyValueToken = QueryConditionalFactory.expressionValue("VAL");
        Expression.Builder result = Expression.builder().expression(String.format(this.template, ex.expression(), propertyValueToken));
        if (ex.expressionNames() != null) {
            ex.expressionNames().forEach((arg_0, arg_1) -> ((Expression.Builder)result).putExpressionName(arg_0, arg_1));
        }
        if (ex.expressionValues() != null) {
            ex.expressionValues().forEach((arg_0, arg_1) -> ((Expression.Builder)result).putExpressionValue(arg_0, arg_1));
        }
        result.putExpressionValue(propertyValueToken, this.value);
        return result.build();
    }
}

