/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.QueryConditionalFactory;
import java.util.Collections;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;

class ConditionalWithSingleStringArgument
implements QueryConditional {
    static final String ATTRIBUTE_EXISTS = "attribute_exists (%s)";
    static final String ATTRIBUTE_NOT_EXISTS = "attribute_not_exists (%s)";
    static final String SIZE = "size (%s)";
    private final String template;
    private final String path;

    ConditionalWithSingleStringArgument(String template, String path) {
        this.template = template;
        this.path = path;
    }

    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        String pathKeyToken = QueryConditionalFactory.expressionKey(this.path);
        String queryExpression = String.format(this.template, pathKeyToken);
        return Expression.builder().expression(queryExpression).expressionNames(Collections.singletonMap(pathKeyToken, this.path)).build();
    }
}

