/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.QueryConditionalFactory;
import java.util.Collections;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

class ConditionalWithThreeArguments
implements QueryConditional {
    static final String BETWEEN_TEMPLATE = "%s BETWEEN %s AND %s";
    private final String template;
    private final String property;
    private final AttributeValue first;
    private final AttributeValue second;

    ConditionalWithThreeArguments(String template, String property, AttributeValue first, AttributeValue second) {
        this.template = template;
        this.property = property;
        this.first = first;
        this.second = second;
    }

    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        String propertyKeyToken = QueryConditionalFactory.expressionKey(this.property);
        String firstValueToken = QueryConditionalFactory.expressionValue(this.property) + "_1";
        String secondValueToken = QueryConditionalFactory.expressionValue(this.property) + "_2";
        String queryExpression = String.format(this.template, propertyKeyToken, firstValueToken, secondValueToken);
        return Expression.builder().expression(queryExpression).expressionNames(Collections.singletonMap(propertyKeyToken, this.property)).putExpressionValue(firstValueToken, this.first).putExpressionValue(secondValueToken, this.second).build();
    }
}

