/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.QueryConditionalFactory;
import java.util.Collections;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

class ConditionalWithTwoArguments
implements QueryConditional {
    static final String EQUAL_TO_TEMPLATE = "%s = %s";
    static final String NOT_EQUAL_TO_TEMPLATE = "%s <> %s";
    static final String LESS_THAN_TEMPLATE = "%s < %s";
    static final String LESS_THAN_OR_EQUAL_TO_TEMPLATE = "%s <= %s";
    static final String GREATER_THAN_TEMPLATE = "%s > %s";
    static final String GREATER_THAN_OR_EQUAL_TO_TEMPLATE = "%s >= %s";
    static final String BEGINS_WITH_TEMPLATE = "begins_with(%s, %s)";
    static final String ATTRIBUTE_TYPE_TEMPLATE = "attribute_type(%s, %s)";
    static final String CONTAINS_TEMPLATE = "contains(%s, %s)";
    private final String template;
    private final String property;
    private final AttributeValue value;

    ConditionalWithTwoArguments(String template, String property, AttributeValue value) {
        this.template = template;
        this.property = property;
        this.value = value;
    }

    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        String propertyKeyToken = QueryConditionalFactory.expressionKey(this.property);
        String propertyValueToken = QueryConditionalFactory.expressionValue(this.property);
        String queryExpression = String.format(this.template, propertyKeyToken, propertyValueToken);
        return Expression.builder().expression(queryExpression).expressionNames(Collections.singletonMap(propertyKeyToken, this.property)).expressionValues(Collections.singletonMap(propertyValueToken, this.value)).build();
    }
}

