/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.QueryConditionalFactory;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

class InListConditional
implements QueryConditional {
    private final String property;
    private final List<AttributeValue> values;

    InListConditional(String property, List<AttributeValue> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("Values cannot be empty");
        }
        this.property = property;
        this.values = values;
    }

    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        Expression.Builder builder = Expression.builder();
        String propertyKeyToken = QueryConditionalFactory.expressionKey(this.property);
        builder.expressionNames(Collections.singletonMap(propertyKeyToken, this.property));
        String valueTokenBase = QueryConditionalFactory.expressionValue(this.property);
        ArrayList<CallSite> valueNames = new ArrayList<CallSite>();
        for (int i = 0; i < this.values.size(); ++i) {
            String valueName = valueTokenBase + "_" + i;
            valueNames.add((CallSite)((Object)valueName));
            builder.putExpressionValue(valueName, this.values.get(i));
        }
        builder.expression(propertyKeyToken + " IN  (" + String.join((CharSequence)", ", valueNames) + ")");
        return builder.build();
    }
}

