/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;

class LogicalConditional
implements QueryConditional {
    static final String AND_TOKEN = " AND ";
    static final String OR_TOKEN = " OR ";
    private final String token;
    private final Iterable<QueryConditional> statements;

    LogicalConditional(String token, Iterable<QueryConditional> statements) {
        this.token = token;
        this.statements = statements;
    }

    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        Expression.Builder builder = Expression.builder();
        List<Expression> expressions = StreamSupport.stream(this.statements.spliterator(), false).map(s -> s.expression(tableSchema, indexName)).collect(Collectors.toList());
        builder.expression(expressions.stream().map(Expression::expression).filter(e -> e != null && !e.isEmpty()).collect(Collectors.joining(this.token)));
        expressions.forEach(ex -> {
            if (ex.expressionNames() != null) {
                ex.expressionNames().forEach((arg_0, arg_1) -> ((Expression.Builder)builder).putExpressionName(arg_0, arg_1));
            }
            if (ex.expressionValues() != null) {
                ex.expressionValues().forEach((arg_0, arg_1) -> ((Expression.Builder)builder).putExpressionValue(arg_0, arg_1));
            }
        });
        return builder.build();
    }
}

