/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.ConditionalWithConditionalAndArgument;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.ConditionalWithSingleStringArgument;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.ConditionalWithThreeArguments;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.ConditionalWithTwoArguments;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.GroupConditional;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.InListConditional;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.LogicalConditional;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.conditional.NotConditional;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class QueryConditionalFactory {
    private static final Random RANDOM = new Random();

    public static QueryConditional attributeExists(String path) {
        return new ConditionalWithSingleStringArgument("attribute_exists (%s)", path);
    }

    public static QueryConditional attributeNotExists(String path) {
        return new ConditionalWithSingleStringArgument("attribute_not_exists (%s)", path);
    }

    public static QueryConditional size(String path) {
        return new ConditionalWithSingleStringArgument("size (%s)", path);
    }

    public static QueryConditional between(String property, AttributeValue lowerBound, AttributeValue upperBound) {
        return new ConditionalWithThreeArguments("%s BETWEEN %s AND %s", property, lowerBound, upperBound);
    }

    public static QueryConditional inList(String property, List<AttributeValue> values) {
        return new InListConditional(property, values);
    }

    public static QueryConditional equalTo(String property, AttributeValue value) {
        return new ConditionalWithTwoArguments("%s = %s", property, value);
    }

    public static QueryConditional notEqualTo(String property, AttributeValue value) {
        return new ConditionalWithTwoArguments("%s <> %s", property, value);
    }

    public static QueryConditional lessThan(String property, AttributeValue value) {
        return new ConditionalWithTwoArguments("%s < %s", property, value);
    }

    public static QueryConditional lessThanOrEqualTo(String property, AttributeValue value) {
        return new ConditionalWithTwoArguments("%s <= %s", property, value);
    }

    public static QueryConditional greaterThan(String property, AttributeValue value) {
        return new ConditionalWithTwoArguments("%s > %s", property, value);
    }

    public static QueryConditional greaterThanOrEqualTo(String property, AttributeValue value) {
        return new ConditionalWithTwoArguments("%s >= %s", property, value);
    }

    public static QueryConditional sizeEqualTo(String path, AttributeValue value) {
        return new ConditionalWithConditionalAndArgument("%s = %s", QueryConditionalFactory.size(path), value);
    }

    public static QueryConditional sizeNotEqualTo(String path, AttributeValue value) {
        return new ConditionalWithConditionalAndArgument("%s <> %s", QueryConditionalFactory.size(path), value);
    }

    public static QueryConditional sizeLessThan(String path, AttributeValue value) {
        return new ConditionalWithConditionalAndArgument("%s < %s", QueryConditionalFactory.size(path), value);
    }

    public static QueryConditional sizeLessThanOrEqualTo(String path, AttributeValue value) {
        return new ConditionalWithConditionalAndArgument("%s <= %s", QueryConditionalFactory.size(path), value);
    }

    public static QueryConditional sizeGreaterThan(String path, AttributeValue value) {
        return new ConditionalWithConditionalAndArgument("%s > %s", QueryConditionalFactory.size(path), value);
    }

    public static QueryConditional sizeGreaterThanOrEqualTo(String path, AttributeValue value) {
        return new ConditionalWithConditionalAndArgument("%s >= %s", QueryConditionalFactory.size(path), value);
    }

    public static QueryConditional contains(String property, AttributeValue value) {
        return new ConditionalWithTwoArguments("contains(%s, %s)", property, value);
    }

    public static QueryConditional beginsWith(String property, String substring) {
        return QueryConditionalFactory.beginsWith(property, AttributeValues.stringValue((String)substring));
    }

    public static QueryConditional beginsWith(String property, AttributeValue value) {
        return new ConditionalWithTwoArguments("begins_with(%s, %s)", property, value);
    }

    public static QueryConditional attributeType(String property, AttributeValue type) {
        return new ConditionalWithTwoArguments("attribute_type(%s, %s)", property, type);
    }

    public static QueryConditional attributeType(String property, AttributeValueType type) {
        return QueryConditionalFactory.attributeType(property, AttributeValues.stringValue((String)type.name()));
    }

    public static QueryConditional attributeType(String property, String type) {
        if (Arrays.stream(AttributeValueType.values()).noneMatch(t -> t.name().equals(type))) {
            throw new IllegalArgumentException("Unrecognized type: " + type);
        }
        return QueryConditionalFactory.attributeType(property, AttributeValues.stringValue((String)type));
    }

    public static QueryConditional attributeTypeIsNull(String property) {
        return QueryConditionalFactory.attributeType(property, AttributeValueType.NULL);
    }

    public static QueryConditional attributeType(String property, Class<?> type) {
        return QueryConditionalFactory.attributeType(property, EnhancedType.of(type));
    }

    public static QueryConditional attributeType(String property, EnhancedType<?> type) {
        if (type == null) {
            return QueryConditionalFactory.attributeType(property, AttributeValueType.NULL);
        }
        if (CharSequence.class.isAssignableFrom(type.rawClass())) {
            return QueryConditionalFactory.attributeType(property, AttributeValueType.S);
        }
        if (Number.class.isAssignableFrom(type.rawClass())) {
            return QueryConditionalFactory.attributeType(property, AttributeValueType.N);
        }
        if (Boolean.class.isAssignableFrom(type.rawClass())) {
            return QueryConditionalFactory.attributeType(property, AttributeValueType.BOOL);
        }
        if (SdkBytes.class.isAssignableFrom(type.rawClass())) {
            return QueryConditionalFactory.attributeType(property, AttributeValueType.B);
        }
        if (Map.class.isAssignableFrom(type.rawClass())) {
            return QueryConditionalFactory.attributeType(property, AttributeValueType.M);
        }
        if (Iterable.class.isAssignableFrom(type.rawClass()) && type.rawClassParameters().size() > 0) {
            Class rawClassParameter = ((EnhancedType)type.rawClassParameters().get(0)).rawClass();
            if (CharSequence.class.isAssignableFrom(rawClassParameter)) {
                return QueryConditionalFactory.attributeType(property, AttributeValues.stringValue((String)"SS"));
            }
            if (Number.class.isAssignableFrom(rawClassParameter)) {
                return QueryConditionalFactory.attributeType(property, AttributeValues.stringValue((String)"NS"));
            }
            if (SdkBytes.class.isAssignableFrom(rawClassParameter)) {
                return QueryConditionalFactory.attributeType(property, AttributeValues.stringValue((String)"BS"));
            }
            return QueryConditionalFactory.attributeType(property, AttributeValueType.L);
        }
        throw new IllegalArgumentException("Cannot determine expected attribute type from " + type);
    }

    public static QueryConditional group(QueryConditional statement) {
        if (statement instanceof GroupConditional) {
            return statement;
        }
        return new GroupConditional(statement);
    }

    public static QueryConditional and(Collection<QueryConditional> statements) {
        if (statements.size() == 1) {
            return statements.iterator().next();
        }
        return new LogicalConditional(" AND ", statements);
    }

    public static QueryConditional and(QueryConditional ... statements) {
        return QueryConditionalFactory.and(Arrays.asList(statements));
    }

    public static QueryConditional or(Collection<QueryConditional> statements) {
        if (statements.size() == 1) {
            return statements.iterator().next();
        }
        return new LogicalConditional(" OR ", statements);
    }

    public static QueryConditional or(QueryConditional ... statements) {
        return QueryConditionalFactory.or(Arrays.asList(statements));
    }

    public static QueryConditional not(QueryConditional statement) {
        return new NotConditional(statement);
    }

    static String expressionKey(String key) {
        return "#AGORA_MAPPED_" + EnhancedClientUtils.cleanAttributeName((String)key) + "_" + RANDOM.nextInt(10000);
    }

    static String expressionValue(String key) {
        return ":AGORA_MAPPED_" + EnhancedClientUtils.cleanAttributeName((String)key) + "_" + RANDOM.nextInt(10000);
    }
}

