/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.convert;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.micronaut.jackson.ObjectMapperFactory;
import java.io.IOException;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class ConvertedJsonAttributeConverter<T>
implements AttributeConverter<T> {
    private static final ObjectWriter OBJECT_WRITER;
    private static final ObjectReader OBJECT_READER;
    private final Class<T> type;

    public ConvertedJsonAttributeConverter(Class<T> type) {
        this.type = type;
    }

    public AttributeValue transformFrom(T input) {
        try {
            return AttributeValue.fromS((String)OBJECT_WRITER.writeValueAsString(input));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot write value as JSON: " + input, e);
        }
    }

    public T transformTo(AttributeValue input) {
        try {
            return (T)OBJECT_READER.readValue(input.s(), this.type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read value: " + input.s(), e);
        }
    }

    public EnhancedType<T> type() {
        return EnhancedType.of(this.type);
    }

    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    static {
        ObjectMapper mapper = new ObjectMapperFactory().objectMapper(null, null);
        OBJECT_READER = mapper.reader();
        OBJECT_WRITER = mapper.writer();
    }
}

