/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.convert;

import java.util.Date;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.InstantAsStringAttributeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DateToStringAttributeConverter
implements AttributeConverter<Date> {
    private static final InstantAsStringAttributeConverter INSTANT_CONVERTER = InstantAsStringAttributeConverter.create();

    public EnhancedType<Date> type() {
        return EnhancedType.of(Date.class);
    }

    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    public AttributeValue transformFrom(Date input) {
        return INSTANT_CONVERTER.transformFrom(input.toInstant());
    }

    public Date transformTo(AttributeValue input) {
        return Date.from(INSTANT_CONVERTER.transformTo(input));
    }
}

