/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.convert;

import io.micronaut.core.util.CollectionUtils;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class EmptySafeStringSetConverter
implements AttributeConverter<Set<String>> {
    public AttributeValue transformFrom(Set<String> set) {
        return CollectionUtils.isEmpty(set) ? AttributeValues.nullAttributeValue() : AttributeValue.fromSs(set.stream().toList());
    }

    public Set<String> transformTo(AttributeValue rawValue) {
        return new HashSet<String>(rawValue.ss());
    }

    public EnhancedType<Set<String>> type() {
        return EnhancedType.setOf(String.class);
    }

    public AttributeValueType attributeValueType() {
        return AttributeValueType.SS;
    }
}

