/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.convert;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.convert.DateToStringAttributeConverter;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.convert.EmptySafeStringSetConverter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.DefaultAttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;

public class LegacyAttributeConverterProvider
implements AttributeConverterProvider {
    private final List<AttributeConverter<?>> customConverters = Arrays.asList(new DateToStringAttributeConverter(), new EmptySafeStringSetConverter());
    private final Map<EnhancedType<?>, AttributeConverter<?>> customConvertersMap;
    private final AttributeConverterProvider defaultProvider = DefaultAttributeConverterProvider.create();

    public LegacyAttributeConverterProvider() {
        this.customConvertersMap = this.customConverters.stream().collect(Collectors.toMap(AttributeConverter::type, c -> c));
    }

    public <T> AttributeConverter<T> converterFor(EnhancedType<T> enhancedType) {
        return this.customConvertersMap.computeIfAbsent(enhancedType, arg_0 -> ((AttributeConverterProvider)this.defaultProvider).converterFor(arg_0));
    }
}

