/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.events;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.events.DynamoDbEventType;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.events.DynamoDbPostLoadEvent;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.events.DynamoDbPostPersistEvent;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.events.DynamoDbPostRemoveEvent;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.events.DynamoDbPostUpdateEvent;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.events.DynamoDbPrePersistEvent;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.events.DynamoDbPreRemoveEvent;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.events.DynamoDbPreUpdateEvent;

public abstract class DynamoDbEvent<T> {
    private final DynamoDbEventType type;
    private final T entity;

    public static <T> DynamoDbPostLoadEvent<T> postLoad(T entity) {
        return new DynamoDbPostLoadEvent<T>(entity);
    }

    public static <T> DynamoDbPrePersistEvent<T> prePersist(T entity) {
        return new DynamoDbPrePersistEvent<T>(entity);
    }

    public static <T> DynamoDbPostPersistEvent<T> postPersist(T entity) {
        return new DynamoDbPostPersistEvent<T>(entity);
    }

    public static <T> DynamoDbPreRemoveEvent<T> preRemove(T entity) {
        return new DynamoDbPreRemoveEvent<T>(entity);
    }

    public static <T> DynamoDbPostRemoveEvent<T> postRemove(T entity) {
        return new DynamoDbPostRemoveEvent<T>(entity);
    }

    public static <T> DynamoDbPreUpdateEvent<T> preUpdate(T entity) {
        return new DynamoDbPreUpdateEvent<T>(entity);
    }

    public static <T> DynamoDbPostUpdateEvent<T> postUpdate(T entity) {
        return new DynamoDbPostUpdateEvent<T>(entity);
    }

    protected DynamoDbEvent(DynamoDbEventType type, T entity) {
        this.type = type;
        this.entity = entity;
    }

    public DynamoDbEventType getType() {
        return this.type;
    }

    public T getEntity() {
        return this.entity;
    }
}

