/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.groovy;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class PathCollector
extends GroovyObjectSupport
implements GroovyObject {
    private final String path;
    private final PathCollector parent;
    private final Map<String, PathCollector> children = new LinkedHashMap<String, PathCollector>();

    public static PathCollector collectPaths(Closure<Object> collector) {
        PathCollector pathCollector = new PathCollector(null, null);
        Closure closure = collector.rehydrate((Object)pathCollector, (Object)pathCollector, (Object)pathCollector);
        closure.setResolveStrategy(3);
        closure.call((Object)pathCollector);
        return pathCollector;
    }

    public PathCollector(PathCollector parent, String path) {
        this.path = path;
        this.parent = parent;
    }

    public Object getProperty(String propertyName) {
        return this.children.computeIfAbsent(propertyName, it -> new PathCollector(this, (String)it));
    }

    public String getFullPath() {
        if (this.parent != null && this.parent.path != null) {
            return this.parent.path + "." + this.path;
        }
        return this.path;
    }

    public List<String> getPropertyPaths() {
        if (!this.children.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>();
            this.children.values().forEach(it -> result.addAll(it.getPropertyPaths()));
            return result;
        }
        return Collections.singletonList(this.getFullPath());
    }
}

