/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.schema;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Attribute;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.ConvertedBy;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.ConvertedJson;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Flatten;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.HashKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Ignore;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.IgnoreNulls;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.PartitionKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.PreserveEmptyObjects;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.RangeKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.SecondaryPartitionKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.SecondarySortKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.SortKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.convert.ConvertedJsonAttributeConverter;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.convert.LegacyAttributeConverterProvider;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.type.Argument;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedTypeDocumentConfiguration;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeConfiguration;
import software.amazon.awssdk.enhanced.dynamodb.internal.DynamoDbEnhancedLogger;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.MetaTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.MetaTableSchemaCache;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.ObjectConstructor;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTags;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.UpdateBehavior;
import software.amazon.awssdk.enhanced.dynamodb.mapper.WrappedTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbBean;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbConvertedBy;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbFlatten;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbIgnore;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbIgnoreNulls;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbPartitionKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbPreserveEmptyObject;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSecondaryPartitionKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSecondarySortKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbSortKey;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbUpdateBehavior;

@SdkPublicApi
@ThreadSafe
public final class BeanIntrospectionTableSchema<T>
extends WrappedTableSchema<T, StaticTableSchema<T>> {
    private static final List<String> PARTITION_KEYS_ANNOTATIONS = Arrays.asList(PartitionKey.class.getName(), HashKey.class.getName(), DynamoDbPartitionKey.class.getName(), "com.agorapulse.micronaut.aws.dynamodb.annotation.HashKey");
    private static final List<String> SORT_KEYS_ANNOTATIONS = Arrays.asList(SortKey.class.getName(), RangeKey.class.getName(), DynamoDbSortKey.class.getName(), "com.agorapulse.micronaut.aws.dynamodb.annotation.RangeKey");
    private static final List<String> SECONDARY_PARTITION_KEYS_ANNOTATIONS = Arrays.asList(SecondaryPartitionKey.class.getName(), DynamoDbSecondaryPartitionKey.class.getName());
    private static final List<String> SECONDARY_SORT_KEYS_ANNOTATIONS = Arrays.asList(SecondarySortKey.class.getName(), DynamoDbSecondarySortKey.class.getName());
    private static final List<String> UPDATE_BEHAVIOUR_ANNOTATIONS = Arrays.asList(com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.UpdateBehavior.class.getName(), DynamoDbUpdateBehavior.class.getName());

    private BeanIntrospectionTableSchema(StaticTableSchema<T> staticTableSchema) {
        super(staticTableSchema);
    }

    public static <T> BeanIntrospectionTableSchema<T> create(Class<T> beanClass, BeanContext context, MetaTableSchemaCache metaTableSchemaCache) {
        BeanIntrospectionTableSchema.debugLog(beanClass, () -> "Creating bean schema");
        MetaTableSchema metaTableSchema = metaTableSchemaCache.getOrCreate(beanClass);
        BeanIntrospectionTableSchema<T> newTableSchema = new BeanIntrospectionTableSchema<T>(BeanIntrospectionTableSchema.createStaticTableSchema(beanClass, context, metaTableSchemaCache));
        if (!metaTableSchema.isInitialized()) {
            metaTableSchema.initialize(newTableSchema);
        }
        return newTableSchema;
    }

    static <T> TableSchema<T> recursiveCreate(Class<T> beanClass, BeanContext context, MetaTableSchemaCache metaTableSchemaCache) {
        Optional metaTableSchema = metaTableSchemaCache.get(beanClass);
        if (metaTableSchema.isPresent()) {
            if (((MetaTableSchema)metaTableSchema.get()).isInitialized()) {
                return ((MetaTableSchema)metaTableSchema.get()).concreteTableSchema();
            }
            return (TableSchema)metaTableSchema.get();
        }
        return BeanIntrospectionTableSchema.create(beanClass, context, metaTableSchemaCache);
    }

    private static <T> StaticTableSchema<T> createStaticTableSchema(Class<T> beanClass, BeanContext beanContext, MetaTableSchemaCache metaTableSchemaCache) {
        Optional introspectionOptional = BeanIntrospector.SHARED.findIntrospection(beanClass);
        if (!introspectionOptional.isPresent()) {
            throw new IllegalArgumentException("A DynamoDb bean class must be annotated with @Introspected, but " + beanClass.getTypeName() + " was not.");
        }
        BeanIntrospection introspection = (BeanIntrospection)introspectionOptional.get();
        StaticTableSchema.Builder builder = StaticTableSchema.builder(beanClass).newItemSupplier(() -> ((BeanIntrospection)introspection).instantiate());
        Optional optionalDynamoDbBean = introspection.findAnnotation(DynamoDbBean.class);
        if (optionalDynamoDbBean.isPresent()) {
            builder.attributeConverterProviders(BeanIntrospectionTableSchema.createConverterProvidersFromAnnotation(beanClass, (AnnotationValue<DynamoDbBean>)((AnnotationValue)optionalDynamoDbBean.get()), beanContext));
        } else {
            builder.attributeConverterProviders(new AttributeConverterProvider[]{new LegacyAttributeConverterProvider()});
        }
        List attributes = introspection.getBeanProperties().stream().filter(p -> BeanIntrospectionTableSchema.isMappableProperty(beanClass, p)).map(propertyDescriptor -> BeanIntrospectionTableSchema.extractAttributeFromProperty(beanClass, metaTableSchemaCache, builder, propertyDescriptor, beanContext)).filter(Objects::nonNull).collect(Collectors.toList());
        builder.attributes(attributes);
        return builder.build();
    }

    private static <T, P> StaticAttribute<T, P> extractAttributeFromProperty(Class<T> beanClass, MetaTableSchemaCache metaTableSchemaCache, StaticTableSchema.Builder<T> builder, BeanProperty<T, P> propertyDescriptor, BeanContext beanContext) {
        Optional<AnnotationValue<Annotation>> dynamoDbFlatten = BeanIntrospectionTableSchema.findAnnotation(propertyDescriptor, new Class[]{DynamoDbFlatten.class, Flatten.class});
        if (dynamoDbFlatten.isPresent()) {
            builder.flatten(BeanIntrospectionTableSchema.create(propertyDescriptor.getType(), beanContext, metaTableSchemaCache), arg_0 -> propertyDescriptor.get(arg_0), (arg_0, arg_1) -> propertyDescriptor.set(arg_0, arg_1));
            return null;
        }
        AttributeConfiguration attributeConfiguration = BeanIntrospectionTableSchema.resolveAttributeConfiguration(propertyDescriptor);
        StaticAttribute.Builder<T, P> attributeBuilder = BeanIntrospectionTableSchema.staticAttributeBuilder(propertyDescriptor, beanClass, metaTableSchemaCache, attributeConfiguration, beanContext);
        BeanIntrospectionTableSchema.createAttributeConverterFromAnnotation(propertyDescriptor, beanContext).ifPresent(arg_0 -> attributeBuilder.attributeConverter(arg_0));
        BeanIntrospectionTableSchema.addTagsToAttribute(attributeBuilder, propertyDescriptor);
        return attributeBuilder.build();
    }

    private static <T> AttributeConfiguration resolveAttributeConfiguration(BeanProperty<T, ?> propertyDescriptor) {
        boolean shouldPreserveEmptyObject = BeanIntrospectionTableSchema.findAnnotation(propertyDescriptor, new Class[]{DynamoDbPreserveEmptyObject.class, PreserveEmptyObjects.class}).isPresent();
        boolean shouldIgnoreNulls = BeanIntrospectionTableSchema.findAnnotation(propertyDescriptor, new Class[]{DynamoDbIgnoreNulls.class, IgnoreNulls.class}).isPresent();
        return AttributeConfiguration.builder().preserveEmptyObject(shouldPreserveEmptyObject).ignoreNulls(shouldIgnoreNulls).build();
    }

    private static List<AttributeConverterProvider> createConverterProvidersFromAnnotation(Class<?> beanClass, AnnotationValue<DynamoDbBean> dynamoDbBean, BeanContext beanContext) {
        Class[] providerClasses = dynamoDbBean.classValues("converterProviders");
        if (providerClasses.length == 0) {
            providerClasses = new Class[]{LegacyAttributeConverterProvider.class};
        }
        return Arrays.stream(providerClasses).peek(c -> BeanIntrospectionTableSchema.debugLog(beanClass, () -> "Adding Converter: " + c.getTypeName())).map(c -> (AttributeConverterProvider)BeanIntrospectionTableSchema.fromContextOrNew(c, beanContext).get()).collect(Collectors.toList());
    }

    private static <T, P> StaticAttribute.Builder<T, P> staticAttributeBuilder(BeanProperty<T, P> propertyDescriptor, Class<T> beanClass, MetaTableSchemaCache metaTableSchemaCache, AttributeConfiguration attributeConfiguration, BeanContext beanContext) {
        Argument propertyType = propertyDescriptor.asArgument();
        EnhancedType<T> propertyTypeToken = BeanIntrospectionTableSchema.convertTypeToEnhancedType(propertyType, metaTableSchemaCache, attributeConfiguration, beanContext);
        return StaticAttribute.builder(beanClass, propertyTypeToken).name(BeanIntrospectionTableSchema.attributeNameForProperty(propertyDescriptor)).getter(arg_0 -> propertyDescriptor.get(arg_0)).setter(propertyDescriptor.isReadOnly() ? (bean, value) -> {} : (arg_0, arg_1) -> propertyDescriptor.set(arg_0, arg_1));
    }

    private static <T> EnhancedType<T> convertTypeToEnhancedType(Argument<T> type, MetaTableSchemaCache metaTableSchemaCache, AttributeConfiguration attributeConfiguration, BeanContext beanContext) {
        Optional introspection;
        if (List.class.equals((Object)type.getType())) {
            EnhancedType<T> enhancedType = BeanIntrospectionTableSchema.convertTypeToEnhancedType(type.getTypeParameters()[0], metaTableSchemaCache, attributeConfiguration, beanContext);
            return EnhancedType.listOf(enhancedType);
        }
        if (Set.class.equals((Object)type.getType())) {
            EnhancedType<T> enhancedType = BeanIntrospectionTableSchema.convertTypeToEnhancedType(type.getTypeParameters()[0], metaTableSchemaCache, attributeConfiguration, beanContext);
            return EnhancedType.setOf(enhancedType);
        }
        if (Map.class.equals((Object)type.getType())) {
            EnhancedType<T> keyType = BeanIntrospectionTableSchema.convertTypeToEnhancedType((Argument)type.getTypeVariable("K").orElseThrow(() -> new IllegalArgumentException("Missing key type")), metaTableSchemaCache, attributeConfiguration, beanContext);
            EnhancedType<T> valueType = BeanIntrospectionTableSchema.convertTypeToEnhancedType((Argument)type.getTypeVariable("V").orElseThrow(() -> new IllegalArgumentException("Missing value type")), metaTableSchemaCache, attributeConfiguration, beanContext);
            return EnhancedType.mapOf(keyType, valueType);
        }
        Class clazz = type.getType();
        if (clazz.getPackage() != null && !clazz.getPackage().getName().startsWith("java.") && (introspection = BeanIntrospector.SHARED.findIntrospection(clazz)).isPresent() && ((BeanIntrospection)introspection.get()).isAnnotationPresent(DynamoDbBean.class)) {
            Consumer<EnhancedTypeDocumentConfiguration.Builder> attrConfiguration = b -> b.preserveEmptyObject(Boolean.valueOf(attributeConfiguration.preserveEmptyObject())).ignoreNulls(Boolean.valueOf(attributeConfiguration.ignoreNulls()));
            return EnhancedType.documentOf((Class)clazz, BeanIntrospectionTableSchema.recursiveCreate(clazz, beanContext, metaTableSchemaCache), attrConfiguration);
        }
        return EnhancedType.of((Class)clazz);
    }

    private static <T, P> Optional<AttributeConverter<P>> createAttributeConverterFromAnnotation(BeanProperty<T, P> propertyDescriptor, BeanContext beanContext) {
        return BeanIntrospectionTableSchema.findAnnotation(propertyDescriptor, new Class[]{DynamoDbConvertedBy.class, ConvertedBy.class}).flatMap(AnnotationValue::classValue).map(clazz -> (AttributeConverter)BeanIntrospectionTableSchema.fromContextOrNew(clazz, beanContext).get()).or(() -> BeanIntrospectionTableSchema.findAnnotation((AnnotationMetadataProvider)propertyDescriptor, ConvertedJson.class).map(anno -> new ConvertedJsonAttributeConverter(propertyDescriptor.getType())));
    }

    private static <T> void addTagsToAttribute(StaticAttribute.Builder<?, ?> attributeBuilder, BeanProperty<T, ?> propertyDescriptor) {
        BeanIntrospectionTableSchema.findAnnotation(propertyDescriptor, UPDATE_BEHAVIOUR_ANNOTATIONS).flatMap(anno -> anno.enumValue(Enum.class)).ifPresent(behavior -> attributeBuilder.addTag(StaticAttributeTags.updateBehavior((UpdateBehavior)UpdateBehavior.valueOf((String)behavior.name()))));
        BeanIntrospectionTableSchema.findAnnotation(propertyDescriptor, PARTITION_KEYS_ANNOTATIONS).ifPresent(anno -> attributeBuilder.addTag(StaticAttributeTags.primaryPartitionKey()));
        BeanIntrospectionTableSchema.findAnnotation(propertyDescriptor, SORT_KEYS_ANNOTATIONS).ifPresent(anno -> attributeBuilder.addTag(StaticAttributeTags.primarySortKey()));
        BeanIntrospectionTableSchema.findAnnotation(propertyDescriptor, SECONDARY_PARTITION_KEYS_ANNOTATIONS).map(anno -> anno.stringValues("indexNames")).ifPresent(indexNames -> attributeBuilder.addTag(StaticAttributeTags.secondaryPartitionKey(Arrays.asList(indexNames))));
        BeanIntrospectionTableSchema.findAnnotation(propertyDescriptor, SECONDARY_SORT_KEYS_ANNOTATIONS).map(anno -> anno.stringValues("indexNames")).ifPresent(indexNames -> attributeBuilder.addTag(StaticAttributeTags.secondarySortKey(Arrays.asList(indexNames))));
    }

    private static <R> Supplier<R> fromContextOrNew(Class<R> clazz, BeanContext beanContext) {
        Optional optionalBean = beanContext.findBean(clazz);
        if (optionalBean.isPresent()) {
            return optionalBean::get;
        }
        Optional optionalBeanIntrospection = BeanIntrospector.SHARED.findIntrospection(clazz);
        if (optionalBeanIntrospection.isPresent()) {
            return () -> ((BeanIntrospection)((BeanIntrospection)optionalBeanIntrospection.get())).instantiate();
        }
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            BeanIntrospectionTableSchema.debugLog(clazz, () -> "Constructor: " + constructor);
            return ObjectConstructor.create(clazz, constructor);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Class '%s' appears to have no default constructor thus cannot be used with the BeanTableSchema", clazz), e);
        }
    }

    private static <T> String attributeNameForProperty(BeanProperty<T, ?> propertyDescriptor) {
        return BeanIntrospectionTableSchema.findAnnotation(propertyDescriptor, new Class[]{DynamoDbAttribute.class, Attribute.class}).flatMap(AnnotationValue::stringValue).orElseGet(() -> propertyDescriptor.getName());
    }

    private static <T> boolean isMappableProperty(Class<T> beanClass, BeanProperty<T, ?> propertyDescriptor) {
        if (propertyDescriptor.isWriteOnly()) {
            BeanIntrospectionTableSchema.debugLog(beanClass, () -> "Ignoring bean property " + propertyDescriptor.getName() + " because it is write only.");
            return false;
        }
        if (propertyDescriptor.isReadOnly()) {
            BeanIntrospectionTableSchema.debugLog(beanClass, () -> "Ignoring bean property " + propertyDescriptor.getName() + " because it is read only.");
            return BeanIntrospectionTableSchema.isSecondaryIndex(propertyDescriptor);
        }
        if (propertyDescriptor.isAnnotationPresent(DynamoDbIgnore.class)) {
            BeanIntrospectionTableSchema.debugLog(beanClass, () -> "Ignoring bean property " + propertyDescriptor.getName() + " because it is ignored.");
            return false;
        }
        if (propertyDescriptor.isAnnotationPresent(Ignore.class)) {
            BeanIntrospectionTableSchema.debugLog(beanClass, () -> "Ignoring bean property " + propertyDescriptor.getName() + " because it is ignored.");
            return false;
        }
        return true;
    }

    private static <T> boolean isSecondaryIndex(BeanProperty<T, ?> propertyDescriptor) {
        return propertyDescriptor.getAnnotationNames().stream().anyMatch(name -> SECONDARY_PARTITION_KEYS_ANNOTATIONS.contains(name) || SECONDARY_SORT_KEYS_ANNOTATIONS.contains(name));
    }

    private static void debugLog(Class<?> beanClass, Supplier<String> logMessage) {
        DynamoDbEnhancedLogger.BEAN_LOGGER.debug(() -> beanClass.getTypeName() + " - " + (String)logMessage.get());
    }

    private static Optional<AnnotationValue<Annotation>> findAnnotation(AnnotationMetadataProvider source, Class<? extends Annotation> ... annotationClasses) {
        for (Class<? extends Annotation> annotationName : annotationClasses) {
            Optional maybeAnno = source.findAnnotation(annotationName);
            if (!maybeAnno.isPresent()) continue;
            return maybeAnno;
        }
        return Optional.empty();
    }

    private static Optional<AnnotationValue<Annotation>> findAnnotation(AnnotationMetadataProvider source, Iterable<String> annotationNames) {
        for (String annotationName : annotationNames) {
            Optional maybeAnno = source.findAnnotation(annotationName);
            if (!maybeAnno.isPresent()) continue;
            return maybeAnno;
        }
        return Optional.empty();
    }
}

