/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.util;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Filter;
import io.micronaut.core.type.Argument;

public class FilterArgument {
    private Argument<?> firstArgument;
    private Argument<?> secondArgument;
    private String name;
    private boolean required;
    private Filter.Operator operator;

    public static String getArgumentName(Argument<?> argument) {
        return argument.isAnnotationPresent(Filter.class) ? argument.getAnnotation(Filter.class).stringValue("name").orElse(argument.getName()) : argument.getName();
    }

    FilterArgument fill(Argument<?> argument) {
        if (this.firstArgument == null) {
            this.fillFirstArgument(argument);
        } else {
            this.secondArgument = argument;
        }
        return this;
    }

    private void fillFirstArgument(Argument<?> argument) {
        this.name = FilterArgument.getArgumentName(argument);
        this.firstArgument = argument;
        this.required = !argument.isNullable();
        this.operator = argument.isAnnotationPresent(Filter.class) ? argument.getAnnotation(Filter.class).enumValue("value", Filter.Operator.class).orElse(Filter.Operator.EQ) : Filter.Operator.EQ;
    }

    public Argument<?> getFirstArgument() {
        return this.firstArgument;
    }

    public Argument<?> getSecondArgument() {
        return this.secondArgument;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Filter.Operator getOperator() {
        return this.operator;
    }
}

