/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.util;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.type.Argument;
import java.util.Optional;
import org.reactivestreams.Publisher;

public class ItemArgument {
    Argument<?> argument;
    boolean single;

    public static <T> Optional<ItemArgument> findItemArgument(Class<T> itemType, MethodInvocationContext<Object, Object> context) {
        Argument[] args = context.getArguments();
        if (args.length == 1) {
            Argument itemArgument = args[0];
            if (itemArgument.getType().isArray() || Iterable.class.isAssignableFrom(itemArgument.getType()) || Publisher.class.isAssignableFrom(itemArgument.getType())) {
                ItemArgument item = new ItemArgument();
                item.argument = itemArgument;
                item.single = false;
                return Optional.of(item);
            }
            if (itemType.isAssignableFrom(itemArgument.getType())) {
                ItemArgument item = new ItemArgument();
                item.argument = itemArgument;
                item.single = true;
                return Optional.of(item);
            }
        }
        return Optional.empty();
    }

    public Argument<?> getArgument() {
        return this.argument;
    }

    public boolean isSingle() {
        return this.single;
    }
}

