/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.dynamodb.util;

import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Consistent;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Descending;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Filter;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.HashKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Index;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.LastEvaluatedKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Limit;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.Page;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.PartitionKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.RangeKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.annotation.SortKey;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.Builders;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.FilterConditionCollector;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.KeyConditionCollector;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.builder.QueryBuilder;
import com.agorapulse.micronaut.amazon.awssdk.dynamodb.util.FilterArgument;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;

public class QueryArguments {
    private static final String PARTITION = "partition";
    private static final String SORT = "sort";
    private static final String HASH = "hash";
    private static final String RANGE = "range";
    private static final String LAST_EVALUATED_KEY = "lastEvaluatedKey";
    private static final String LIMIT = "limit";
    private static final String PAGE = "page";
    private final Map<String, FilterArgument> filters = new LinkedHashMap<String, FilterArgument>();
    private Argument<?> partitionKey;
    private FilterArgument sortKey;
    private String index;
    private boolean consistent;
    private boolean descending;
    private Argument<?> lastEvaluatedKey;
    private Argument<?> limit;
    private Argument<?> page;

    public static <T> QueryArguments create(MethodInvocationContext<Object, Object> context, TableMetadata tableMetadata, Class<T> itemType) {
        Argument[] arguments;
        QueryArguments queryArguments = new QueryArguments();
        queryArguments.index = context.getTargetMethod().isAnnotationPresent(Index.class) ? context.getTargetMethod().getAnnotation(Index.class).value() : null;
        queryArguments.consistent = context.getTargetMethod().isAnnotationPresent(Consistent.class) && context.getTargetMethod().getAnnotation(Consistent.class).value();
        queryArguments.descending = context.getTargetMethod().isAnnotationPresent(Descending.class) && context.getTargetMethod().getAnnotation(Descending.class).value();
        for (Argument argument : arguments = context.getArguments()) {
            if (argument.isAnnotationPresent(SortKey.class) || argument.isAnnotationPresent(RangeKey.class) || argument.getName().toLowerCase().contains(SORT) || argument.getName().toLowerCase().contains(RANGE) || argument.getName().equals(tableMetadata.primarySortKey().orElse(SORT))) {
                if (queryArguments.sortKey == null) {
                    queryArguments.sortKey = new FilterArgument();
                }
                queryArguments.sortKey.fill(argument);
                continue;
            }
            if (argument.isAnnotationPresent(PartitionKey.class) || argument.isAnnotationPresent(HashKey.class) || argument.getName().toLowerCase().contains(PARTITION) || argument.getName().toLowerCase().contains(HASH) || argument.getName().equals(tableMetadata.primaryPartitionKey())) {
                queryArguments.partitionKey = argument;
                continue;
            }
            if (argument.isAnnotationPresent(LastEvaluatedKey.class) || argument.getName().toLowerCase().contains(LAST_EVALUATED_KEY)) {
                if (!argument.getType().equals(itemType)) {
                    throw new UnsupportedOperationException("Last evaluated key must be of the same type as the entity");
                }
                queryArguments.lastEvaluatedKey = argument;
                continue;
            }
            if (argument.isAnnotationPresent(Limit.class) || argument.getName().toLowerCase().contains(LIMIT)) {
                queryArguments.limit = argument;
                continue;
            }
            if (argument.isAnnotationPresent(Page.class) || argument.getName().toLowerCase().contains(PAGE)) {
                queryArguments.page = argument;
                continue;
            }
            String name = FilterArgument.getArgumentName(argument);
            queryArguments.filters.computeIfAbsent(name, argName -> new FilterArgument()).fill(argument);
        }
        if (!queryArguments.isValid()) {
            throw new UnsupportedOperationException("Method needs to have at least one argument annotated with @PartitionKey or with called 'partition'");
        }
        return queryArguments;
    }

    public static <T> Publisher<T> toPublisher(ConversionService conversionService, Class<T> type, Argument<?> itemArgument, Map<String, MutableArgumentValue<?>> params) {
        Object item = params.get(itemArgument.getName()).getValue();
        if (Publishers.isConvertibleToPublisher((Class)itemArgument.getType()) && type.isAssignableFrom(itemArgument.getTypeParameters()[0].getType())) {
            if (Publisher.class.isAssignableFrom(itemArgument.getType())) {
                return (Publisher)item;
            }
            return (Publisher)Publishers.convertPublisher((ConversionService)conversionService, (Object)item, Publisher.class);
        }
        if (itemArgument.getType().isArray() && type.isAssignableFrom(itemArgument.getType().getComponentType())) {
            return Flux.fromArray((Object[])((Object[])item));
        }
        if (Iterable.class.isAssignableFrom(itemArgument.getType()) && type.isAssignableFrom(itemArgument.getTypeParameters()[0].getType())) {
            return Flux.fromIterable((Iterable)((Iterable)item));
        }
        return Flux.just((Object)item);
    }

    public boolean hasSortKey() {
        return this.sortKey != null;
    }

    boolean isValid() {
        return this.partitionKey != null;
    }

    public Object getPartitionValue(Map<String, MutableArgumentValue<?>> params) {
        return params.get(this.partitionKey.getName()).getValue();
    }

    public Object getSortValue(Map<String, MutableArgumentValue<?>> params) {
        return this.sortKey == null ? null : params.get(this.sortKey.getFirstArgument().getName()).getValue();
    }

    public Publisher<?> getSortAttributeValues(ConversionService conversionService, Map<String, MutableArgumentValue<?>> params) {
        return this.sortKey == null ? Flux.empty() : QueryArguments.toPublisher(conversionService, Object.class, this.sortKey.getFirstArgument(), params);
    }

    public Publisher<?> getPartitionAttributeValues(ConversionService conversionService, Map<String, MutableArgumentValue<?>> params) {
        return this.partitionKey == null ? Flux.empty() : QueryArguments.toPublisher(conversionService, Object.class, this.partitionKey, params);
    }

    public <T> Consumer<QueryBuilder<T>> generateQuery(MethodInvocationContext<Object, Object> context, ConversionService conversionService) {
        return q -> {
            Object secondSortValue;
            if (this.index != null) {
                q.index(this.index);
            }
            q.partitionKey(this.getPartitionValue(context.getParameters()));
            Object sortValue = this.getSortValue(context.getParameters());
            Object object = secondSortValue = this.sortKey == null || this.sortKey.getSecondArgument() == null ? null : ((MutableArgumentValue)context.getParameters().get(this.sortKey.getSecondArgument().getName())).getValue();
            if (sortValue != null) {
                q.sortKey(s -> this.sortKey.getOperator().apply((KeyConditionCollector<?>)s, this.sortKey.getName(), sortValue, secondSortValue));
            }
            if (this.consistent) {
                q.consistent(Builders.Read.READ);
            }
            if (this.descending) {
                q.order(Builders.Sort.DESC);
            }
            if (!this.filters.isEmpty()) {
                this.filters.forEach((name, filter) -> {
                    Object secondValue;
                    Object firstValue = ((MutableArgumentValue)context.getParameters().get(filter.getFirstArgument().getName())).getValue();
                    Object object = secondValue = filter.getSecondArgument() == null ? null : ((MutableArgumentValue)context.getParameters().get(filter.getSecondArgument().getName())).getValue();
                    if (firstValue == null && !filter.isRequired()) {
                        return;
                    }
                    q.filter(f -> filter.getOperator().apply((FilterConditionCollector<?>)f, (String)name, firstValue, secondValue));
                });
            }
            if (this.lastEvaluatedKey != null) {
                q.lastEvaluatedKey(((MutableArgumentValue)context.getParameters().get(this.lastEvaluatedKey.getName())).getValue());
            }
            if (this.limit != null) {
                q.limit((Integer)conversionService.convertRequired(((MutableArgumentValue)context.getParameters().get(this.limit.getName())).getValue(), Integer.class));
            }
            if (this.page != null) {
                q.page((Integer)conversionService.convertRequired(((MutableArgumentValue)context.getParameters().get(this.page.getName())).getValue(), Integer.class));
            }
        };
    }

    public boolean isSortKeyPublisherOrIterable() {
        return this.sortKey.getFirstArgument().getType().isArray() || Iterable.class.isAssignableFrom(this.sortKey.getFirstArgument().getType()) || Publisher.class.isAssignableFrom(this.sortKey.getFirstArgument().getType());
    }

    public boolean isPartitionKeyPublisherOrIterable() {
        return this.partitionKey.getType().isArray() || Iterable.class.isAssignableFrom(this.partitionKey.getType()) || Publisher.class.isAssignableFrom(this.partitionKey.getType());
    }

    public boolean isCustomized() {
        return this.index != null || this.consistent || this.descending || !this.filters.isEmpty() || this.sortKey != null && this.sortKey.getOperator() != Filter.Operator.EQ || this.lastEvaluatedKey != null || this.limit != null || this.page != null;
    }
}

