/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.s3;

import com.agorapulse.micronaut.amazon.awssdk.s3.SimpleStorageService;
import io.micronaut.http.multipart.PartData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAclResponse;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedPutObjectRequest;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Md5Utils;

public class DefaultSimpleStorageService
implements SimpleStorageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSimpleStorageService.class);
    private final S3Client s3;
    private final S3Presigner presigner;
    private final String defaultBucketName;

    public DefaultSimpleStorageService(String bucket, S3Client s3, S3Presigner presigner) {
        this.s3 = s3;
        this.defaultBucketName = bucket;
        this.presigner = presigner;
    }

    @Override
    public String getDefaultBucketName() {
        return this.defaultBucketName;
    }

    @Override
    public void createBucket(String bucketName) {
        this.s3.createBucket(b -> b.bucket(bucketName));
    }

    @Override
    public void deleteBucket(String bucketName) {
        this.s3.deleteBucket(b -> b.bucket(bucketName));
    }

    @Override
    public boolean deleteFile(String bucketName, String key) {
        try {
            this.s3.deleteObject(b -> b.bucket(bucketName).key(key));
            return true;
        }
        catch (AwsServiceException | SdkClientException e) {
            LOGGER.warn(String.format("Exception deleting object %s/%s", bucketName, key), e);
            return false;
        }
    }

    @Override
    public boolean deleteFiles(String bucketName, String prefix) {
        if (prefix.split("/").length >= 2) {
            throw new IllegalArgumentException("Multiple delete are only allowed in sub/sub directories: " + prefix);
        }
        return Flux.from(this.listObjectSummaries(bucketName, prefix)).map(o -> this.deleteFile(bucketName, o.key())).onErrorResume(throwable -> {
            LOGGER.warn(String.format("Exception deleting objects in %s/%s", bucketName, prefix), throwable);
            return Mono.just((Object)false);
        }).filter(r -> r == false).count().blockOptional().map(Long::intValue).orElse(0) == 0;
    }

    @Override
    public boolean exists(String bucketName, String key) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        try {
            return this.getObject(bucketName, key) != null;
        }
        catch (AwsServiceException | SdkClientException e) {
            LOGGER.warn(String.format("Exception obtaining object existence %s/%s", bucketName, key), e);
            return false;
        }
    }

    @Override
    public GetObjectResponse getObject(String bucketName, String key) {
        GetObjectResponse getObjectResponse;
        block8: {
            ResponseInputStream stream = this.s3.getObject(b -> b.bucket(bucketName).key(key));
            try {
                getObjectResponse = (GetObjectResponse)stream.response();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Exception closing stream", e);
                }
            }
            stream.close();
        }
        return getObjectResponse;
    }

    @Override
    public File getFile(String bucketName, String key, File localFile) {
        this.s3.getObject(b -> b.bucket(bucketName).key(key), localFile.toPath());
        return localFile;
    }

    @Override
    public List<String> listBucketNames() {
        return this.s3.listBuckets().buckets().stream().map(Bucket::name).collect(Collectors.toList());
    }

    @Override
    public Publisher<ListObjectsV2Response> listObjects(String bucketName, String prefix) {
        return Flux.fromIterable((Iterable)this.s3.listObjectsV2Paginator(b -> b.bucket(bucketName).prefix(prefix)));
    }

    @Override
    public String generatePresignedUrl(String bucketName, String key, Date expirationDate) {
        PresignedGetObjectRequest request = this.presigner.presignGetObject(b -> b.getObjectRequest(r -> r.bucket(bucketName).key(key)).signatureDuration(Duration.between(Instant.now(), expirationDate.toInstant())));
        return request.url().toExternalForm();
    }

    @Override
    public String generateUploadUrl(String bucketName, String key, Date expirationDate) {
        PresignedPutObjectRequest request = this.presigner.presignPutObject(b -> b.putObjectRequest(r -> r.bucket(bucketName).key(key)).signatureDuration(Duration.between(Instant.now(), expirationDate.toInstant())));
        return request.url().toExternalForm();
    }

    @Override
    public String storeInputStream(String bucketName, String path, InputStream input, Consumer<PutObjectRequest.Builder> additionalConfig) {
        try {
            this.s3.putObject(b -> {
                additionalConfig.accept((PutObjectRequest.Builder)b);
                b.bucket(bucketName).key(path);
            }, RequestBody.fromBytes((byte[])IoUtils.toByteArray((InputStream)input)));
            return this.s3.utilities().getUrl(b -> b.bucket(bucketName).key(path)).toExternalForm();
        }
        catch (IOException | AwsServiceException exception) {
            return "";
        }
    }

    @Override
    public String storeFile(String bucketName, String path, File file, Consumer<PutObjectRequest.Builder> additionalConfig) {
        try {
            this.s3.putObject(b -> {
                b.bucket(bucketName).key(path);
                additionalConfig.accept((PutObjectRequest.Builder)b);
            }, RequestBody.fromFile((File)file));
            return this.s3.utilities().getUrl(b -> b.bucket(bucketName).key(path)).toExternalForm();
        }
        catch (AwsServiceException exception) {
            return "";
        }
    }

    @Override
    public String storeMultipartFile(String bucketName, String path, PartData partData, Consumer<PutObjectRequest.Builder> additionalConfig) throws IOException {
        byte[] bytes = partData.getBytes();
        return this.storeInputStream(bucketName, path, partData.getInputStream(), b -> {
            b.contentLength(Long.valueOf(Integer.valueOf(bytes.length).longValue()));
            b.contentMD5(Md5Utils.md5AsBase64((byte[])bytes));
            partData.getContentType().ifPresent(t -> b.contentType(t.getName()));
            additionalConfig.accept((PutObjectRequest.Builder)b);
        });
    }

    @Override
    public String moveObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        try {
            CopyObjectRequest.Builder request = CopyObjectRequest.builder().copySource(sourceBucketName + "/" + sourceKey).destinationBucket(destinationBucketName).destinationKey(destinationKey);
            this.s3.copyObject((CopyObjectRequest)request.build());
            GetObjectAclResponse acl = this.s3.getObjectAcl(b -> b.bucket(sourceBucketName).key(sourceKey));
            this.s3.putObjectAcl(b -> b.bucket(destinationBucketName).key(destinationKey).accessControlPolicy(p -> p.owner(acl.owner()).grants((Collection)acl.grants())));
            this.s3.deleteObject(b -> b.bucket(sourceBucketName).key(sourceKey));
            return this.s3.utilities().getUrl(b -> b.bucket(destinationBucketName).key(destinationKey)).toExternalForm();
        }
        catch (AwsServiceException e) {
            LOGGER.error(String.format("Exception moving object %s/%s to %s/%s", sourceBucketName, sourceKey, destinationBucketName, destinationKey), (Throwable)e);
            return null;
        }
    }
}

