/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.s3;

import io.micronaut.http.multipart.PartData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

public interface SimpleStorageService {
    public String getDefaultBucketName();

    public void createBucket(String var1);

    default public void createBucket() {
        this.createBucket(this.getDefaultBucketName());
    }

    public void deleteBucket(String var1);

    default public void deleteBucket() {
        this.deleteBucket(this.getDefaultBucketName());
    }

    public boolean deleteFile(String var1, String var2);

    default public boolean deleteFile(String key) {
        return this.deleteFile(this.getDefaultBucketName(), key);
    }

    public boolean deleteFiles(String var1, String var2);

    default public boolean deleteFiles(String prefix) {
        return this.deleteFiles(this.getDefaultBucketName(), prefix);
    }

    public boolean exists(String var1, String var2);

    default public boolean exists(String key) {
        return this.exists(this.getDefaultBucketName(), key);
    }

    public File getFile(String var1, String var2, File var3);

    default public File getFile(String bucketName, String key, String localPath) {
        return this.getFile(bucketName, key, new File(localPath));
    }

    default public File getFile(String key, File localPath) {
        return this.getFile(this.getDefaultBucketName(), key, localPath);
    }

    default public File getFile(String key, String localPath) {
        return this.getFile(this.getDefaultBucketName(), key, localPath);
    }

    public List<String> listBucketNames();

    public Publisher<ListObjectsV2Response> listObjects(String var1, String var2);

    default public Publisher<ListObjectsV2Response> listObjects(String prefix) {
        return this.listObjects(this.getDefaultBucketName(), prefix);
    }

    default public Publisher<ListObjectsV2Response> listObjects() {
        return this.listObjects("");
    }

    default public Publisher<S3Object> listObjectSummaries(String bucketName, String prefix) {
        return Flux.from(this.listObjects(bucketName, prefix)).flatMap(l -> Flux.fromIterable((Iterable)l.contents()));
    }

    default public GetObjectResponse getObject(String key) {
        return this.getObject(this.getDefaultBucketName(), key);
    }

    public GetObjectResponse getObject(String var1, String var2);

    default public S3Object getObjectSummary(String key) {
        return this.getObjectSummary(this.getDefaultBucketName(), key);
    }

    default public S3Object getObjectSummary(String bucketName, String key) {
        return (S3Object)Flux.from(this.listObjectSummaries(bucketName, key)).blockFirst();
    }

    default public Publisher<S3Object> listObjectSummaries(String prefix) {
        return this.listObjectSummaries(this.getDefaultBucketName(), prefix);
    }

    default public Publisher<S3Object> listObjectSummaries() {
        return this.listObjectSummaries("");
    }

    public String generatePresignedUrl(String var1, String var2, Date var3);

    default public String generatePresignedUrl(String key, Date expirationDate) {
        return this.generatePresignedUrl(this.getDefaultBucketName(), key, expirationDate);
    }

    public String generateUploadUrl(String var1, String var2, Date var3);

    default public String generateUploadUrl(String key, Date expirationDate) {
        return this.generateUploadUrl(this.getDefaultBucketName(), key, expirationDate);
    }

    public String storeInputStream(String var1, String var2, InputStream var3, Consumer<PutObjectRequest.Builder> var4);

    default public String storeInputStream(String path, InputStream input, Consumer<PutObjectRequest.Builder> metadataDefinition) {
        return this.storeInputStream(this.getDefaultBucketName(), path, input, metadataDefinition);
    }

    default public String storeInputStream(String bucketName, String path, InputStream input) {
        return this.storeInputStream(bucketName, path, input, b -> {});
    }

    default public String storeInputStream(String path, InputStream input) {
        return this.storeInputStream(this.getDefaultBucketName(), path, input);
    }

    public String storeFile(String var1, String var2, File var3, Consumer<PutObjectRequest.Builder> var4);

    default public String storeFile(String path, File file, Consumer<PutObjectRequest.Builder> metadataDefinition) {
        return this.storeFile(this.getDefaultBucketName(), path, file, metadataDefinition);
    }

    default public String storeFile(String bucketName, String path, File file) {
        return this.storeFile(bucketName, path, file, b -> {});
    }

    default public String storeFile(String path, File file) {
        return this.storeFile(this.getDefaultBucketName(), path, file);
    }

    public String storeMultipartFile(String var1, String var2, PartData var3, Consumer<PutObjectRequest.Builder> var4) throws IOException;

    default public String storeMultipartFile(String bucketName, String path, PartData partData) throws IOException {
        return this.storeMultipartFile(bucketName, path, partData, b -> {});
    }

    default public String storeMultipartFile(String path, PartData multipartFile) throws IOException {
        return this.storeMultipartFile(this.getDefaultBucketName(), path, multipartFile);
    }

    default public String storeMultipartFile(String path, PartData multipartFile, Consumer<PutObjectRequest.Builder> metadataDefinition) throws IOException {
        return this.storeMultipartFile(this.getDefaultBucketName(), path, multipartFile, metadataDefinition);
    }

    public String moveObject(String var1, String var2, String var3, String var4);

    default public String moveObject(String sourceKey, String destinationBucketName, String destinationKey) {
        return this.moveObject(this.getDefaultBucketName(), sourceKey, destinationBucketName, destinationKey);
    }
}

