/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.s3;

import com.agorapulse.micronaut.amazon.awssdk.s3.DefaultSimpleStorageService;
import com.agorapulse.micronaut.amazon.awssdk.s3.SimpleStorageService;
import com.agorapulse.micronaut.amazon.awssdk.s3.SimpleStorageServiceConfiguration;
import io.micronaut.aws.sdk.v2.service.s3.S3ClientFactory;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Replaces;
import jakarta.inject.Singleton;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

@Factory
public class SimpleStorageServiceFactory {
    @Singleton
    @EachBean(value=SimpleStorageServiceConfiguration.class)
    @Replaces(bean=S3Client.class, factory=S3ClientFactory.class)
    public S3Client s3Client(AwsCredentialsProvider credentialsProvider, AwsRegionProvider awsRegionProvider, SimpleStorageServiceConfiguration configuration) {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)configuration.configure((AwsClientBuilder)S3Client.builder(), awsRegionProvider)).credentialsProvider(credentialsProvider)).forcePathStyle(configuration.getForcePathStyle())).build();
    }

    @Singleton
    @EachBean(value=SimpleStorageServiceConfiguration.class)
    public S3Presigner s3Presigner(AwsCredentialsProvider credentialsProvider, AwsRegionProvider awsRegionProvider, SimpleStorageServiceConfiguration configuration) {
        S3Presigner.Builder builder = ((S3Presigner.Builder)configuration.configure((SdkPresigner.Builder)S3Presigner.builder(), awsRegionProvider)).credentialsProvider(credentialsProvider);
        if (configuration.getForcePathStyle() != null) {
            builder.serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(configuration.getForcePathStyle()).build());
        }
        return builder.build();
    }

    @Singleton
    @EachBean(value=SimpleStorageServiceConfiguration.class)
    @Replaces(bean=S3AsyncClient.class, factory=S3ClientFactory.class)
    public S3AsyncClient s3AsyncClient(AwsCredentialsProvider credentialsProvider, AwsRegionProvider awsRegionProvider, SimpleStorageServiceConfiguration configuration, Optional<SdkAsyncHttpClient> httpClient) {
        S3AsyncClientBuilder builder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().forcePathStyle(configuration.getForcePathStyle())).credentialsProvider(credentialsProvider);
        httpClient.ifPresent(arg_0 -> ((S3AsyncClientBuilder)builder).httpClient(arg_0));
        configuration.configure((AwsClientBuilder)builder, awsRegionProvider);
        return (S3AsyncClient)builder.build();
    }

    @Singleton
    @EachBean(value=SimpleStorageServiceConfiguration.class)
    public SimpleStorageService simpleStorageService(S3Client s3, S3Presigner presigner, SimpleStorageServiceConfiguration configuration) {
        return new DefaultSimpleStorageService(configuration.getBucket(), s3, presigner);
    }
}

