/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.sts;

import com.agorapulse.micronaut.amazon.awssdk.sts.SecurityTokenService;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.function.Consumer;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;

@Singleton
@Requires(classes={StsClient.class})
public class DefaultSecurityTokenService
implements SecurityTokenService {
    private final StsClient client;

    public DefaultSecurityTokenService(StsClient client) {
        this.client = client;
    }

    @Override
    public AssumeRoleResponse assumeRole(String sessionName, String roleArn, int durationInSeconds, Consumer<AssumeRoleRequest.Builder> additionParameters) {
        AssumeRoleRequest.Builder request = AssumeRoleRequest.builder().roleSessionName(sessionName).roleArn(roleArn).durationSeconds(Integer.valueOf(durationInSeconds));
        additionParameters.accept(request);
        return this.client.assumeRole((AssumeRoleRequest)request.build());
    }
}

