/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.amazon.awssdk.sts;

import com.agorapulse.micronaut.amazon.awssdk.sts.SecurityTokenServiceConfiguration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.services.sts.StsAsyncClient;
import software.amazon.awssdk.services.sts.StsAsyncClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;

@Factory
@Requires(classes={StsClient.class})
public class SecurityTokenServiceFactory {
    @Bean
    @Singleton
    StsClient awsSecurityTokenService(AwsCredentialsProvider credentialsProvider, AwsRegionProvider awsRegionProvider, SecurityTokenServiceConfiguration configuration) {
        return (StsClient)((StsClientBuilder)configuration.configure((AwsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(credentialsProvider)), awsRegionProvider)).build();
    }

    @Bean
    @Singleton
    StsAsyncClient awsSecurityTokenAsyncService(AwsCredentialsProvider credentialsProvider, AwsRegionProvider awsRegionProvider, SecurityTokenServiceConfiguration configuration, Optional<SdkAsyncHttpClient> httpClient) {
        StsAsyncClientBuilder builder = (StsAsyncClientBuilder)StsAsyncClient.builder().credentialsProvider(credentialsProvider);
        configuration.configure((AwsClientBuilder)builder, awsRegionProvider);
        httpClient.ifPresent(arg_0 -> ((StsAsyncClientBuilder)builder).httpClient(arg_0));
        return (StsAsyncClient)builder.build();
    }
}

